/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupervisorDetails {
    private static final Logger LOG = LoggerFactory.getLogger(SupervisorDetails.class);
    String id;
    String host;
    Object meta;
    Object schedulerMeta;
    Set<Integer> allPorts;
    private Map<String, Double> _total_resources;

    public SupervisorDetails(String id, String host, Object meta, Object schedulerMeta, Collection<? extends Number> allPorts, Map<String, Double> total_resources) {
        this.id = id;
        this.host = host;
        this.meta = meta;
        this.schedulerMeta = schedulerMeta;
        if (allPorts != null) {
            this.setAllPorts(allPorts);
        } else {
            this.allPorts = new HashSet<Integer>();
        }
        this._total_resources = total_resources;
        LOG.debug("Creating a new supervisor ({}-{}) with resources: {}", new Object[]{this.host, this.id, total_resources});
    }

    public SupervisorDetails(String id, Object meta) {
        this(id, null, meta, null, null, null);
    }

    public SupervisorDetails(String id, Object meta, Map<String, Double> total_resources) {
        this(id, null, meta, null, null, total_resources);
    }

    public SupervisorDetails(String id, Object meta, Collection<? extends Number> allPorts) {
        this(id, null, meta, null, allPorts, null);
    }

    public SupervisorDetails(String id, String host, Object schedulerMeta, Collection<? extends Number> allPorts) {
        this(id, host, null, schedulerMeta, allPorts, null);
    }

    public SupervisorDetails(String id, String host, Object schedulerMeta, Collection<? extends Number> allPorts, Map<String, Double> total_resources) {
        this(id, host, null, schedulerMeta, allPorts, total_resources);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " ID: " + this.id + " HOST: " + this.host + " META: " + this.meta + " SCHED_META: " + this.schedulerMeta + " PORTS: " + this.allPorts;
    }

    private void setAllPorts(Collection<? extends Number> allPorts) {
        this.allPorts = new HashSet<Integer>();
        if (allPorts != null) {
            for (Number number : allPorts) {
                this.allPorts.add(number.intValue());
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public String getHost() {
        return this.host;
    }

    public Object getMeta() {
        return this.meta;
    }

    public Set<Integer> getAllPorts() {
        return this.allPorts;
    }

    public Object getSchedulerMeta() {
        return this.schedulerMeta;
    }

    private Double getTotalResource(String type) {
        return this._total_resources.get(type);
    }

    public Double getTotalMemory() {
        Double totalMemory = this.getTotalResource("supervisor.memory.capacity.mb");
        assert (totalMemory != null);
        return totalMemory;
    }

    public Double getTotalCPU() {
        Double totalCPU = this.getTotalResource("supervisor.cpu.capacity");
        assert (totalCPU != null);
        return totalCPU;
    }
}

