/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.storm.scheduler.TopologyDetails;
import org.apache.storm.scheduler.resource.Component;

public class Topologies {
    Map<String, TopologyDetails> topologies;
    Map<String, String> nameToId;
    Map<String, Map<String, Component>> _allComponents;

    public Topologies(Map<String, TopologyDetails> topologies) {
        if (topologies == null) {
            topologies = new HashMap<String, TopologyDetails>();
        }
        this.topologies = new HashMap<String, TopologyDetails>(topologies.size());
        this.topologies.putAll(topologies);
        this.nameToId = new HashMap<String, String>(topologies.size());
        for (Map.Entry<String, TopologyDetails> entry : topologies.entrySet()) {
            TopologyDetails topology = entry.getValue();
            this.nameToId.put(topology.getName(), entry.getKey());
        }
    }

    public Topologies(Topologies src) {
        this(src.topologies);
    }

    public TopologyDetails getById(String topologyId) {
        return this.topologies.get(topologyId);
    }

    public TopologyDetails getByName(String topologyName) {
        String topologyId = this.nameToId.get(topologyName);
        if (topologyId == null) {
            return null;
        }
        return this.getById(topologyId);
    }

    public Collection<TopologyDetails> getTopologies() {
        return this.topologies.values();
    }

    public Map<String, Map<String, Component>> getAllComponents() {
        if (this._allComponents == null) {
            this._allComponents = new HashMap<String, Map<String, Component>>();
            for (Map.Entry<String, TopologyDetails> entry : this.topologies.entrySet()) {
                this._allComponents.put(entry.getKey(), entry.getValue().getComponents());
            }
        }
        return this._allComponents;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append("Topologies:\n");
        for (TopologyDetails td : this.getTopologies()) {
            ret.append(td.toString()).append("\n");
        }
        return ret.toString();
    }
}

