/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler;

public class WorkerSlot {
    private String nodeId;
    private int port;
    private double memOnHeap = 0.0;
    private double memOffHeap = 0.0;
    private double cpu = 0.0;

    public WorkerSlot(String nodeId, Number port) {
        this(nodeId, port, 0.0, 0.0, 0.0);
    }

    public WorkerSlot(String nodeId, Number port, double memOnHeap, double memOffHeap, double cpu) {
        this.nodeId = nodeId;
        this.port = port.intValue();
        this.memOnHeap = memOnHeap;
        this.memOffHeap = memOffHeap;
        this.cpu = cpu;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public int getPort() {
        return this.port;
    }

    public String getId() {
        return this.getNodeId() + ":" + this.getPort();
    }

    public double getAllocatedMemOnHeap() {
        return this.memOnHeap;
    }

    public double getAllocatedMemOffHeap() {
        return this.memOffHeap;
    }

    public double getAllocatedCpu() {
        return this.cpu;
    }

    public int hashCode() {
        return this.nodeId.hashCode() + 13 * Integer.valueOf(this.port).hashCode();
    }

    public boolean equals(Object o) {
        WorkerSlot other = (WorkerSlot)o;
        return this.port == other.port && this.nodeId.equals(other.nodeId);
    }

    public String toString() {
        return this.nodeId + ":" + this.port;
    }
}

