/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.apache.storm.scheduler.Cluster;
import org.apache.storm.scheduler.ExecutorDetails;
import org.apache.storm.scheduler.SchedulerAssignment;
import org.apache.storm.scheduler.SupervisorDetails;
import org.apache.storm.scheduler.Topologies;
import org.apache.storm.scheduler.TopologyDetails;
import org.apache.storm.scheduler.WorkerSlot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RAS_Node {
    private static final Logger LOG = LoggerFactory.getLogger(RAS_Node.class);
    Map<String, WorkerSlot> _slots = new HashMap<String, WorkerSlot>();
    private Map<String, Map<String, Collection<ExecutorDetails>>> _topIdToUsedSlots = new HashMap<String, Map<String, Collection<ExecutorDetails>>>();
    private final String _nodeId;
    private String _hostname;
    private boolean _isAlive;
    private SupervisorDetails _sup;
    private Double _availMemory = 0.0;
    private Double _availCPU = 0.0;
    private final Cluster _cluster;
    private final Topologies _topologies;

    public RAS_Node(String nodeId, SupervisorDetails sup, Cluster cluster, Topologies topologies, Map<String, WorkerSlot> workerIdToWorker, Map<String, Map<String, Collection<ExecutorDetails>>> assignmentMap) {
        this._nodeId = nodeId;
        this._isAlive = sup == null ? false : !cluster.isBlackListed(this._nodeId);
        this._cluster = cluster;
        this._topologies = topologies;
        if (workerIdToWorker != null) {
            this._slots = workerIdToWorker;
        }
        if (assignmentMap != null) {
            this._topIdToUsedSlots = assignmentMap;
        }
        if (this._isAlive && sup != null) {
            this._hostname = sup.getHost();
            this._sup = sup;
            this._availMemory = this.getTotalMemoryResources();
            this._availCPU = this.getTotalCpuResources();
            this.intializeResources();
        }
    }

    private void intializeResources() {
        for (Map.Entry<String, Map<String, Collection<ExecutorDetails>>> entry : this._topIdToUsedSlots.entrySet()) {
            String topoId = entry.getKey();
            Map<String, Collection<ExecutorDetails>> assignment = entry.getValue();
            Map<ExecutorDetails, Double> topoMemoryResourceList = this._topologies.getById(topoId).getTotalMemoryResourceList();
            for (Collection<ExecutorDetails> execs : assignment.values()) {
                for (ExecutorDetails exec : execs) {
                    if (!this._isAlive) continue;
                    if (topoMemoryResourceList.containsKey(exec)) {
                        this.consumeResourcesforTask(exec, this._topologies.getById(topoId));
                        continue;
                    }
                    throw new IllegalStateException("Executor " + exec + "not found!");
                }
            }
        }
    }

    public String getId() {
        return this._nodeId;
    }

    public String getHostname() {
        return this._hostname;
    }

    private Collection<WorkerSlot> workerIdsToWorkers(Collection<String> workerIds) {
        LinkedList<WorkerSlot> ret = new LinkedList<WorkerSlot>();
        for (String workerId : workerIds) {
            ret.add(this._slots.get(workerId));
        }
        return ret;
    }

    public Collection<String> getFreeSlotsId() {
        if (!this._isAlive) {
            return new HashSet<String>();
        }
        Collection<String> usedSlotsId = this.getUsedSlotsId();
        HashSet<String> ret = new HashSet<String>();
        ret.addAll(this._slots.keySet());
        ret.removeAll(usedSlotsId);
        return ret;
    }

    public Collection<WorkerSlot> getFreeSlots() {
        return this.workerIdsToWorkers(this.getFreeSlotsId());
    }

    public Collection<String> getUsedSlotsId() {
        LinkedList<String> ret = new LinkedList<String>();
        for (Map<String, Collection<ExecutorDetails>> entry : this._topIdToUsedSlots.values()) {
            ret.addAll(entry.keySet());
        }
        return ret;
    }

    public Collection<WorkerSlot> getUsedSlots() {
        return this.workerIdsToWorkers(this.getUsedSlotsId());
    }

    public Collection<WorkerSlot> getUsedSlots(String topId) {
        return this.workerIdsToWorkers(this._topIdToUsedSlots.get(topId).keySet());
    }

    public boolean isAlive() {
        return this._isAlive;
    }

    public Collection<String> getRunningTopologies() {
        return this._topIdToUsedSlots.keySet();
    }

    public boolean isTotallyFree() {
        return this.getUsedSlots().isEmpty();
    }

    public int totalSlotsFree() {
        return this.getFreeSlots().size();
    }

    public int totalSlotsUsed() {
        return this.getUsedSlots().size();
    }

    public int totalSlots() {
        return this._slots.size();
    }

    public int totalSlotsUsed(String topId) {
        return this.getUsedSlots(topId).size();
    }

    public void freeAllSlots() {
        if (!this._isAlive) {
            LOG.warn("Freeing all slots on a dead node {} ", (Object)this._nodeId);
        }
        this._cluster.freeSlots(this._slots.values());
        this._availCPU = this.getTotalCpuResources();
        this._availMemory = this.getAvailableMemoryResources();
        this._topIdToUsedSlots.clear();
    }

    public void free(WorkerSlot ws) {
        LOG.info("freeing WorkerSlot {} on node {}", (Object)ws, (Object)this._hostname);
        if (!this._slots.containsKey(ws.getId())) {
            throw new IllegalArgumentException("Tried to free a slot " + ws + " that was not part of this node " + this._nodeId);
        }
        TopologyDetails topo = this.findTopologyUsingWorker(ws);
        if (topo == null) {
            throw new IllegalArgumentException("Tried to free a slot " + ws + " that was already free!");
        }
        double memUsed = this.getMemoryUsedByWorker(ws);
        double cpuUsed = this.getCpuUsedByWorker(ws);
        this.freeMemory(memUsed);
        this.freeCPU(cpuUsed);
        this._cluster.freeSlot(ws);
        this._topIdToUsedSlots.get(topo.getId()).remove(ws.getId());
    }

    private void freeMemory(double amount) {
        LOG.debug("freeing {} memory on node {}...avail mem: {}", new Object[]{amount, this.getHostname(), this._availMemory});
        if (this._availMemory + amount > this.getTotalMemoryResources()) {
            LOG.warn("Freeing more memory than there exists! Memory trying to free: {} Total memory on Node: {}", (Object)(this._availMemory + amount), (Object)this.getTotalMemoryResources());
            return;
        }
        this._availMemory = this._availMemory + amount;
    }

    private void freeCPU(double amount) {
        LOG.debug("freeing {} CPU on node...avail CPU: {}", new Object[]{amount, this.getHostname(), this._availCPU});
        if (this._availCPU + amount > this.getTotalCpuResources()) {
            LOG.warn("Freeing more CPU than there exists! CPU trying to free: {} Total CPU on Node: {}", (Object)(this._availCPU + amount), (Object)this.getTotalCpuResources());
            return;
        }
        this._availCPU = this._availCPU + amount;
    }

    public double getMemoryUsedByWorker(WorkerSlot ws) {
        TopologyDetails topo = this.findTopologyUsingWorker(ws);
        if (topo == null) {
            return 0.0;
        }
        Collection<ExecutorDetails> execs = RAS_Node.getExecutors(ws, this._cluster);
        double totalMemoryUsed = 0.0;
        for (ExecutorDetails exec : execs) {
            totalMemoryUsed += topo.getTotalMemReqTask(exec).doubleValue();
        }
        return totalMemoryUsed;
    }

    public double getCpuUsedByWorker(WorkerSlot ws) {
        TopologyDetails topo = this.findTopologyUsingWorker(ws);
        if (topo == null) {
            return 0.0;
        }
        Collection<ExecutorDetails> execs = RAS_Node.getExecutors(ws, this._cluster);
        double totalCpuUsed = 0.0;
        for (ExecutorDetails exec : execs) {
            totalCpuUsed += topo.getTotalCpuReqTask(exec).doubleValue();
        }
        return totalCpuUsed;
    }

    public TopologyDetails findTopologyUsingWorker(WorkerSlot ws) {
        for (Map.Entry<String, Map<String, Collection<ExecutorDetails>>> entry : this._topIdToUsedSlots.entrySet()) {
            String topoId = entry.getKey();
            Set<String> workerIds = entry.getValue().keySet();
            for (String workerId : workerIds) {
                if (!ws.getId().equals(workerId)) continue;
                return this._topologies.getById(topoId);
            }
        }
        return null;
    }

    public void assign(WorkerSlot target, TopologyDetails td, Collection<ExecutorDetails> executors) {
        if (!this._isAlive) {
            throw new IllegalStateException("Trying to adding to a dead node " + this._nodeId);
        }
        Collection<WorkerSlot> freeSlots = this.getFreeSlots();
        if (freeSlots.isEmpty()) {
            throw new IllegalStateException("Trying to assign to a full node " + this._nodeId);
        }
        if (executors.size() == 0) {
            LOG.warn("Trying to assign nothing from " + td.getId() + " to " + this._nodeId + " (Ignored)");
        }
        if (target == null) {
            target = this.getFreeSlots().iterator().next();
        }
        if (!freeSlots.contains(target)) {
            throw new IllegalStateException("Trying to assign already used slot" + target.getPort() + "on node " + this._nodeId);
        }
        LOG.info("target slot: {}", (Object)target);
        this._cluster.assign(target, td.getId(), executors);
        if (!this._topIdToUsedSlots.containsKey(td.getId())) {
            this._topIdToUsedSlots.put(td.getId(), new HashMap());
        }
        if (!this._topIdToUsedSlots.get(td.getId()).containsKey(target.getId())) {
            this._topIdToUsedSlots.get(td.getId()).put(target.getId(), new LinkedList());
        }
        this._topIdToUsedSlots.get(td.getId()).get(target.getId()).addAll(executors);
    }

    public boolean equals(Object other) {
        if (other instanceof RAS_Node) {
            return this._nodeId.equals(((RAS_Node)other)._nodeId);
        }
        return false;
    }

    public int hashCode() {
        return this._nodeId.hashCode();
    }

    public String toString() {
        return "{Node: " + (this._sup == null ? "null (possibly down)" : this._sup.getHost()) + ", Avail [ Mem: " + (this._availMemory == null ? "N/A" : this._availMemory.toString()) + ", CPU: " + (this._availCPU == null ? "N/A" : this._availCPU.toString()) + ", Slots: " + this.getFreeSlots() + "] Total [ Mem: " + (this._sup == null ? "N/A" : this.getTotalMemoryResources()) + ", CPU: " + (this._sup == null ? "N/A" : this.getTotalCpuResources()) + ", Slots: " + this._slots.values() + " ]}";
    }

    public static int countSlotsUsed(String topId, Collection<RAS_Node> nodes) {
        int total = 0;
        for (RAS_Node n : nodes) {
            total += n.totalSlotsUsed(topId);
        }
        return total;
    }

    public static int countSlotsUsed(Collection<RAS_Node> nodes) {
        int total = 0;
        for (RAS_Node n : nodes) {
            total += n.totalSlotsUsed();
        }
        return total;
    }

    public static int countFreeSlotsAlive(Collection<RAS_Node> nodes) {
        int total = 0;
        for (RAS_Node n : nodes) {
            if (!n.isAlive()) continue;
            total += n.totalSlotsFree();
        }
        return total;
    }

    public static int countTotalSlotsAlive(Collection<RAS_Node> nodes) {
        int total = 0;
        for (RAS_Node n : nodes) {
            if (!n.isAlive()) continue;
            total += n.totalSlots();
        }
        return total;
    }

    public static Collection<ExecutorDetails> getExecutors(WorkerSlot ws, Cluster cluster) {
        ArrayList<ExecutorDetails> retList = new ArrayList<ExecutorDetails>();
        for (Map.Entry<String, SchedulerAssignment> entry : cluster.getAssignments().entrySet()) {
            Map<ExecutorDetails, WorkerSlot> executorToSlot = entry.getValue().getExecutorToSlot();
            for (Map.Entry<ExecutorDetails, WorkerSlot> execToSlot : executorToSlot.entrySet()) {
                WorkerSlot slot = execToSlot.getValue();
                if (ws.getPort() != slot.getPort() || !ws.getNodeId().equals(slot.getNodeId())) continue;
                ExecutorDetails exec = execToSlot.getKey();
                retList.add(exec);
            }
        }
        return retList;
    }

    public void setAvailableMemory(Double amount) {
        this._availMemory = amount;
    }

    public Double getAvailableMemoryResources() {
        if (this._availMemory == null) {
            return 0.0;
        }
        return this._availMemory;
    }

    public Double getTotalMemoryResources() {
        if (this._sup != null && this._sup.getTotalMemory() != null) {
            return this._sup.getTotalMemory();
        }
        return 0.0;
    }

    public Double consumeMemory(Double amount) {
        if (amount > this._availMemory) {
            LOG.error("Attempting to consume more memory than available! Needed: {}, we only have: {}", (Object)amount, (Object)this._availMemory);
            throw new IllegalStateException("Attempting to consume more memory than available");
        }
        this._availMemory = this._availMemory - amount;
        return this._availMemory;
    }

    public Double getAvailableCpuResources() {
        if (this._availCPU == null) {
            return 0.0;
        }
        return this._availCPU;
    }

    public Double getTotalCpuResources() {
        if (this._sup != null && this._sup.getTotalCPU() != null) {
            return this._sup.getTotalCPU();
        }
        return 0.0;
    }

    public Double consumeCPU(Double amount) {
        if (amount > this._availCPU) {
            LOG.error("Attempting to consume more CPU than available! Needed: {}, we only have: {}", (Object)amount, (Object)this._availCPU);
            throw new IllegalStateException("Attempting to consume more CPU than available");
        }
        this._availCPU = this._availCPU - amount;
        return this._availCPU;
    }

    public void consumeResourcesforTask(ExecutorDetails exec, TopologyDetails topo) {
        Double taskMemReq = topo.getTotalMemReqTask(exec);
        Double taskCpuReq = topo.getTotalCpuReqTask(exec);
        this.consumeCPU(taskCpuReq);
        this.consumeMemory(taskMemReq);
    }

    public void freeResourcesForTask(ExecutorDetails exec, TopologyDetails topo) {
        Double taskMemReq = topo.getTotalMemReqTask(exec);
        Double taskCpuReq = topo.getTotalCpuReqTask(exec);
        this.freeCPU(taskCpuReq);
        this.freeMemory(taskMemReq);
    }
}

