/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.resource;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.storm.scheduler.Cluster;
import org.apache.storm.scheduler.ExecutorDetails;
import org.apache.storm.scheduler.SchedulerAssignment;
import org.apache.storm.scheduler.SupervisorDetails;
import org.apache.storm.scheduler.Topologies;
import org.apache.storm.scheduler.WorkerSlot;
import org.apache.storm.scheduler.resource.RAS_Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RAS_Nodes {
    private Map<String, RAS_Node> nodeMap;
    private static final Logger LOG = LoggerFactory.getLogger(RAS_Nodes.class);

    public RAS_Nodes(Cluster cluster, Topologies topologies) {
        this.nodeMap = RAS_Nodes.getAllNodesFrom(cluster, topologies);
    }

    public static Map<String, RAS_Node> getAllNodesFrom(Cluster cluster, Topologies topologies) {
        Object topId;
        HashMap<String, RAS_Node> nodeIdToNode = new HashMap<String, RAS_Node>();
        HashMap assignmentRelationshipMap = new HashMap();
        HashMap workerIdToWorker = new HashMap();
        for (SchedulerAssignment schedulerAssignment : cluster.getAssignments().values()) {
            topId = schedulerAssignment.getTopologyId();
            for (Map.Entry<WorkerSlot, Collection<ExecutorDetails>> entry : schedulerAssignment.getSlotToExecutors().entrySet()) {
                WorkerSlot slot = entry.getKey();
                String nodeId = slot.getNodeId();
                Collection<ExecutorDetails> execs = entry.getValue();
                if (!assignmentRelationshipMap.containsKey(nodeId)) {
                    assignmentRelationshipMap.put(nodeId, new HashMap());
                    workerIdToWorker.put(nodeId, new HashMap());
                }
                ((Map)workerIdToWorker.get(nodeId)).put(slot.getId(), slot);
                if (!((Map)assignmentRelationshipMap.get(nodeId)).containsKey(topId)) {
                    ((Map)assignmentRelationshipMap.get(nodeId)).put(topId, new HashMap());
                }
                if (!((Map)((Map)assignmentRelationshipMap.get(nodeId)).get(topId)).containsKey(slot.getId())) {
                    ((Map)((Map)assignmentRelationshipMap.get(nodeId)).get(topId)).put(slot.getId(), new LinkedList());
                }
                ((Collection)((Map)((Map)assignmentRelationshipMap.get(nodeId)).get(topId)).get(slot.getId())).addAll(execs);
            }
        }
        for (SupervisorDetails supervisorDetails : cluster.getSupervisors().values()) {
            topId = supervisorDetails.getAllPorts().iterator();
            while (topId.hasNext()) {
                int port = (Integer)topId.next();
                WorkerSlot worker = new WorkerSlot(supervisorDetails.getId(), port);
                if (!workerIdToWorker.containsKey(supervisorDetails.getId())) {
                    workerIdToWorker.put(supervisorDetails.getId(), new HashMap());
                }
                if (((Map)workerIdToWorker.get(supervisorDetails.getId())).containsKey(worker.getId())) continue;
                ((Map)workerIdToWorker.get(supervisorDetails.getId())).put(worker.getId(), worker);
            }
            nodeIdToNode.put(supervisorDetails.getId(), new RAS_Node(supervisorDetails.getId(), supervisorDetails, cluster, topologies, (Map)workerIdToWorker.get(supervisorDetails.getId()), (Map)assignmentRelationshipMap.get(supervisorDetails.getId())));
        }
        for (Map.Entry entry : assignmentRelationshipMap.entrySet()) {
            String nodeId = (String)entry.getKey();
            Map assignments = (Map)entry.getValue();
            if (nodeIdToNode.containsKey(nodeId)) continue;
            LOG.info("Found an assigned slot(s) on a dead supervisor {} with assignments {}", (Object)nodeId, (Object)assignments);
            nodeIdToNode.put(nodeId, new RAS_Node(nodeId, null, cluster, topologies, (Map)workerIdToWorker.get(nodeId), assignments));
        }
        return nodeIdToNode;
    }

    public RAS_Node getNodeById(String nodeId) {
        return this.nodeMap.get(nodeId);
    }

    public void freeSlots(Collection<WorkerSlot> workerSlots) {
        for (RAS_Node node : this.nodeMap.values()) {
            for (WorkerSlot ws : node.getUsedSlots()) {
                if (!workerSlots.contains(ws)) continue;
                LOG.debug("freeing ws {} on node {}", (Object)ws, (Object)node);
                node.free(ws);
            }
        }
    }

    public Collection<RAS_Node> getNodes() {
        return this.nodeMap.values();
    }

    public String toString() {
        String ret = "";
        for (RAS_Node node : this.nodeMap.values()) {
            ret = ret + node.toString() + "\n";
        }
        return ret;
    }
}

