/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.scheduler.resource;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.storm.generated.Bolt;
import org.apache.storm.generated.SpoutSpec;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.scheduler.Cluster;
import org.apache.storm.scheduler.ExecutorDetails;
import org.apache.storm.scheduler.Topologies;
import org.apache.storm.scheduler.TopologyDetails;
import org.apache.storm.scheduler.WorkerSlot;
import org.apache.storm.utils.ObjectReader;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ResourceUtils.class);

    public static Map<String, Map<String, Double>> getBoltsResources(StormTopology topology, Map<String, Object> topologyConf) {
        HashMap<String, Map<String, Double>> boltResources = new HashMap<String, Map<String, Double>>();
        if (topology.get_bolts() != null) {
            for (Map.Entry<String, Bolt> bolt : topology.get_bolts().entrySet()) {
                Map<String, Double> topology_resources = ResourceUtils.parseResources(bolt.getValue().get_common().get_json_conf());
                ResourceUtils.checkIntialization(topology_resources, bolt.getValue().toString(), topologyConf);
                boltResources.put(bolt.getKey(), topology_resources);
            }
        }
        return boltResources;
    }

    public static Map<String, Map<String, Double>> getSpoutsResources(StormTopology topology, Map<String, Object> topologyConf) {
        HashMap<String, Map<String, Double>> spoutResources = new HashMap<String, Map<String, Double>>();
        if (topology.get_spouts() != null) {
            for (Map.Entry<String, SpoutSpec> spout : topology.get_spouts().entrySet()) {
                Map<String, Double> topology_resources = ResourceUtils.parseResources(spout.getValue().get_common().get_json_conf());
                ResourceUtils.checkIntialization(topology_resources, spout.getValue().toString(), topologyConf);
                spoutResources.put(spout.getKey(), topology_resources);
            }
        }
        return spoutResources;
    }

    public static void checkIntialization(Map<String, Double> topology_resources, String Com, Map<String, Object> topologyConf) {
        ResourceUtils.checkInitMem(topology_resources, Com, topologyConf);
        ResourceUtils.checkInitCPU(topology_resources, Com, topologyConf);
    }

    public static void checkInitMem(Map<String, Double> topology_resources, String Com, Map<String, Object> topologyConf) {
        if (!topology_resources.containsKey("topology.component.resources.onheap.memory.mb")) {
            topology_resources.put("topology.component.resources.onheap.memory.mb", ObjectReader.getDouble(topologyConf.get("topology.component.resources.onheap.memory.mb"), null));
            ResourceUtils.debugMessage("ONHEAP", Com, topologyConf);
        }
        if (!topology_resources.containsKey("topology.component.resources.offheap.memory.mb")) {
            topology_resources.put("topology.component.resources.offheap.memory.mb", ObjectReader.getDouble(topologyConf.get("topology.component.resources.offheap.memory.mb"), null));
            ResourceUtils.debugMessage("OFFHEAP", Com, topologyConf);
        }
    }

    public static void checkInitCPU(Map<String, Double> topology_resources, String Com, Map<String, Object> topologyConf) {
        if (!topology_resources.containsKey("topology.component.cpu.pcore.percent")) {
            topology_resources.put("topology.component.cpu.pcore.percent", ObjectReader.getDouble(topologyConf.get("topology.component.cpu.pcore.percent"), null));
            ResourceUtils.debugMessage("CPU", Com, topologyConf);
        }
    }

    public static Map<String, Double> parseResources(String input) {
        HashMap<String, Double> topology_resources = new HashMap<String, Double>();
        JSONParser parser = new JSONParser();
        LOG.debug("Input to parseResources {}", (Object)input);
        try {
            if (input != null) {
                Object obj = parser.parse(input);
                JSONObject jsonObject = (JSONObject)obj;
                if (jsonObject.containsKey((Object)"topology.component.resources.onheap.memory.mb")) {
                    Double topoMemOnHeap = ObjectReader.getDouble(jsonObject.get((Object)"topology.component.resources.onheap.memory.mb"), null);
                    topology_resources.put("topology.component.resources.onheap.memory.mb", topoMemOnHeap);
                }
                if (jsonObject.containsKey((Object)"topology.component.resources.offheap.memory.mb")) {
                    Double topoMemOffHeap = ObjectReader.getDouble(jsonObject.get((Object)"topology.component.resources.offheap.memory.mb"), null);
                    topology_resources.put("topology.component.resources.offheap.memory.mb", topoMemOffHeap);
                }
                if (jsonObject.containsKey((Object)"topology.component.cpu.pcore.percent")) {
                    Double topoCPU = ObjectReader.getDouble(jsonObject.get((Object)"topology.component.cpu.pcore.percent"), null);
                    topology_resources.put("topology.component.cpu.pcore.percent", topoCPU);
                }
                LOG.debug("Topology Resources {}", topology_resources);
            }
        }
        catch (ParseException e) {
            LOG.error("Failed to parse component resources is:" + e.toString(), (Throwable)e);
            return null;
        }
        return topology_resources;
    }

    private static void debugMessage(String memoryType, String Com, Map<String, Object> topologyConf) {
        if (memoryType.equals("ONHEAP")) {
            LOG.debug("Unable to extract resource requirement for Component {} \n Resource : Memory Type : On Heap set to default {}", (Object)Com, topologyConf.get("topology.component.resources.onheap.memory.mb"));
        } else if (memoryType.equals("OFFHEAP")) {
            LOG.debug("Unable to extract resource requirement for Component {} \n Resource : Memory Type : Off Heap set to default {}", (Object)Com, topologyConf.get("topology.component.resources.offheap.memory.mb"));
        } else {
            LOG.debug("Unable to extract resource requirement for Component {} \n Resource : CPU Pcore Percent set to default {}", (Object)Com, topologyConf.get("topology.component.cpu.pcore.percent"));
        }
    }

    public static String printScheduling(Cluster cluster, Topologies topologies) {
        StringBuilder str = new StringBuilder();
        HashMap schedulingMap = new HashMap();
        for (TopologyDetails topologyDetails : topologies.getTopologies()) {
            if (cluster.getAssignmentById(topologyDetails.getId()) == null) continue;
            for (Map.Entry<ExecutorDetails, WorkerSlot> entry : cluster.getAssignmentById(topologyDetails.getId()).getExecutorToSlot().entrySet()) {
                WorkerSlot slot = entry.getValue();
                String nodeId = slot.getNodeId();
                ExecutorDetails exec = entry.getKey();
                if (!schedulingMap.containsKey(nodeId)) {
                    schedulingMap.put(nodeId, new HashMap());
                }
                if (!((Map)schedulingMap.get(nodeId)).containsKey(topologyDetails.getId())) {
                    ((Map)schedulingMap.get(nodeId)).put(topologyDetails.getId(), new HashMap());
                }
                if (!((Map)((Map)schedulingMap.get(nodeId)).get(topologyDetails.getId())).containsKey(slot)) {
                    ((Map)((Map)schedulingMap.get(nodeId)).get(topologyDetails.getId())).put(slot, new LinkedList());
                }
                ((Collection)((Map)((Map)schedulingMap.get(nodeId)).get(topologyDetails.getId())).get(slot)).add(exec);
            }
        }
        for (Map.Entry entry : schedulingMap.entrySet()) {
            if (cluster.getSupervisorById((String)entry.getKey()) != null) {
                str.append("/** Node: " + cluster.getSupervisorById((String)entry.getKey()).getHost() + "-" + (String)entry.getKey() + " **/\n");
            } else {
                str.append("/** Node: Unknown may be dead -" + (String)entry.getKey() + " **/\n");
            }
            for (Map.Entry<ExecutorDetails, WorkerSlot> entry2 : ((Map)schedulingMap.get(entry.getKey())).entrySet()) {
                str.append("\t-->Topology: " + (String)((Object)entry2.getKey()) + "\n");
                for (Map.Entry ws : ((Map)((Object)entry2.getValue())).entrySet()) {
                    str.append("\t\t->Slot [" + ((WorkerSlot)ws.getKey()).getPort() + "] -> " + ws.getValue() + "\n");
                }
            }
        }
        return str.toString();
    }

    public static double sum(Collection<Double> list) {
        double sum = 0.0;
        for (Double elem : list) {
            sum += elem.doubleValue();
        }
        return sum;
    }

    public static double avg(Collection<Double> list) {
        return ResourceUtils.sum(list) / (double)list.size();
    }
}

