/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSaslClientCallbackHandler
implements CallbackHandler {
    protected static final String USERNAME = "username";
    protected static final String PASSWORD = "password";
    private static final Logger LOG = LoggerFactory.getLogger(AbstractSaslClientCallbackHandler.class);
    protected String _username = null;
    protected String _password = null;

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback c : callbacks) {
            if (c instanceof NameCallback) {
                LOG.debug("name callback");
                NameCallback nc = (NameCallback)c;
                nc.setName(this._username);
                continue;
            }
            if (c instanceof PasswordCallback) {
                LOG.debug("password callback");
                PasswordCallback pc = (PasswordCallback)c;
                if (this._password == null) continue;
                pc.setPassword(this._password.toCharArray());
                continue;
            }
            if (c instanceof AuthorizeCallback) {
                LOG.debug("authorization callback");
                AuthorizeCallback ac = (AuthorizeCallback)c;
                String authid = ac.getAuthenticationID();
                String authzid = ac.getAuthorizationID();
                if (authid.equals(authzid)) {
                    ac.setAuthorized(true);
                } else {
                    ac.setAuthorized(false);
                }
                if (!ac.isAuthorized()) continue;
                ac.setAuthorizedID(authzid);
                continue;
            }
            if (c instanceof RealmCallback) {
                RealmCallback rc = (RealmCallback)c;
                ((RealmCallback)c).setText(rc.getDefaultText());
                continue;
            }
            throw new UnsupportedCallbackException(c);
        }
    }
}

