/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.URIParameter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.AppConfigurationEntry;
import javax.security.auth.login.Configuration;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;
import org.apache.storm.security.INimbusCredentialPlugin;
import org.apache.storm.security.auth.IAutoCredentials;
import org.apache.storm.security.auth.ICredentialsRenewer;
import org.apache.storm.security.auth.IGroupMappingServiceProvider;
import org.apache.storm.security.auth.IHttpCredentialsPlugin;
import org.apache.storm.security.auth.IPrincipalToLocal;
import org.apache.storm.security.auth.ITransportPlugin;
import org.apache.storm.security.auth.ThriftConnectionType;
import org.apache.storm.utils.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthUtils {
    private static final Logger LOG = LoggerFactory.getLogger(AuthUtils.class);
    public static final String LOGIN_CONTEXT_SERVER = "StormServer";
    public static final String LOGIN_CONTEXT_CLIENT = "StormClient";
    public static final String LOGIN_CONTEXT_PACEMAKER_DIGEST = "PacemakerDigest";
    public static final String LOGIN_CONTEXT_PACEMAKER_SERVER = "PacemakerServer";
    public static final String LOGIN_CONTEXT_PACEMAKER_CLIENT = "PacemakerClient";
    public static final String SERVICE = "storm_thrift_server";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";

    public static Configuration GetConfiguration(Map<String, Object> topoConf) {
        Configuration login_conf = null;
        String loginConfigurationFile = (String)topoConf.get("java.security.auth.login.config");
        if (loginConfigurationFile != null && loginConfigurationFile.length() > 0) {
            File config_file = new File(loginConfigurationFile);
            if (!config_file.canRead()) {
                throw new RuntimeException("File " + loginConfigurationFile + " cannot be read.");
            }
            try {
                URI config_uri = config_file.toURI();
                login_conf = Configuration.getInstance("JavaLoginConfig", new URIParameter(config_uri));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return login_conf;
    }

    public static AppConfigurationEntry[] getEntries(Configuration configuration, String section) throws IOException {
        if (configuration == null) {
            return null;
        }
        AppConfigurationEntry[] configurationEntries = configuration.getAppConfigurationEntry(section);
        if (configurationEntries == null) {
            String errorMessage = "Could not find a '" + section + "' entry in this configuration.";
            throw new IOException(errorMessage);
        }
        return configurationEntries;
    }

    public static SortedMap<String, ?> pullConfig(Configuration configuration, String section) throws IOException {
        AppConfigurationEntry[] configurationEntries = AuthUtils.getEntries(configuration, section);
        if (configurationEntries == null) {
            return null;
        }
        TreeMap results = new TreeMap();
        for (AppConfigurationEntry entry : configurationEntries) {
            Map<String, ?> options = entry.getOptions();
            for (String key : options.keySet()) {
                results.put(key, options.get(key));
            }
        }
        return results;
    }

    public static String get(Configuration configuration, String section, String key) throws IOException {
        AppConfigurationEntry[] configurationEntries = AuthUtils.getEntries(configuration, section);
        if (configurationEntries == null) {
            return null;
        }
        for (AppConfigurationEntry entry : configurationEntries) {
            Object val = entry.getOptions().get(key);
            if (val == null) continue;
            return (String)val;
        }
        return null;
    }

    public static IPrincipalToLocal GetPrincipalToLocalPlugin(Map<String, Object> topoConf) {
        IPrincipalToLocal ptol = null;
        try {
            String ptol_klassName = (String)topoConf.get("storm.principal.tolocal");
            if (ptol_klassName == null) {
                LOG.warn("No principal to local given {}", (Object)"storm.principal.tolocal");
            } else {
                ptol = (IPrincipalToLocal)ReflectionUtils.newInstance(ptol_klassName);
                if (ptol != null) {
                    ptol.prepare(topoConf);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ptol;
    }

    public static IGroupMappingServiceProvider GetGroupMappingServiceProviderPlugin(Map<String, Object> conf) {
        IGroupMappingServiceProvider gmsp = null;
        try {
            String gmsp_klassName = (String)conf.get("storm.group.mapping.service");
            if (gmsp_klassName == null) {
                LOG.warn("No group mapper given {}", (Object)"storm.group.mapping.service");
            } else {
                gmsp = (IGroupMappingServiceProvider)ReflectionUtils.newInstance(gmsp_klassName);
                if (gmsp != null) {
                    gmsp.prepare(conf);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return gmsp;
    }

    public static Collection<ICredentialsRenewer> GetCredentialRenewers(Map<String, Object> conf) {
        try {
            HashSet<ICredentialsRenewer> ret = new HashSet<ICredentialsRenewer>();
            Collection clazzes = (Collection)conf.get("nimbus.credential.renewers.classes");
            if (clazzes != null) {
                for (String clazz : clazzes) {
                    ICredentialsRenewer inst = (ICredentialsRenewer)ReflectionUtils.newInstance(clazz);
                    inst.prepare(conf);
                    ret.add(inst);
                }
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Collection<INimbusCredentialPlugin> getNimbusAutoCredPlugins(Map<String, Object> conf) {
        try {
            HashSet<INimbusCredentialPlugin> ret = new HashSet<INimbusCredentialPlugin>();
            Collection clazzes = (Collection)conf.get("nimbus.autocredential.plugins.classes");
            if (clazzes != null) {
                for (String clazz : clazzes) {
                    INimbusCredentialPlugin inst = (INimbusCredentialPlugin)ReflectionUtils.newInstance(clazz);
                    inst.prepare(conf);
                    ret.add(inst);
                }
            }
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Collection<IAutoCredentials> GetAutoCredentials(Map<String, Object> topoConf) {
        try {
            HashSet<IAutoCredentials> autos = new HashSet<IAutoCredentials>();
            Collection clazzes = (Collection)topoConf.get("topology.auto-credentials");
            if (clazzes != null) {
                for (String clazz : clazzes) {
                    IAutoCredentials a = (IAutoCredentials)ReflectionUtils.newInstance(clazz);
                    a.prepare(topoConf);
                    autos.add(a);
                }
            }
            LOG.info("Got AutoCreds " + autos);
            return autos;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static Subject populateSubject(Subject subject, Collection<IAutoCredentials> autos, Map<String, String> credentials) {
        try {
            if (subject == null) {
                subject = new Subject();
            }
            for (IAutoCredentials autoCred : autos) {
                autoCred.populateSubject(subject, credentials);
            }
            return subject;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void updateSubject(Subject subject, Collection<IAutoCredentials> autos, Map<String, String> credentials) {
        if (subject == null || autos == null) {
            throw new RuntimeException("The subject or auto credentials cannot be null when updating a subject with credentials");
        }
        try {
            for (IAutoCredentials autoCred : autos) {
                autoCred.updateSubject(subject, credentials);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ITransportPlugin GetTransportPlugin(ThriftConnectionType type, Map<String, Object> topoConf, Configuration login_conf) {
        try {
            String transport_plugin_klassName = type.getTransportPlugin(topoConf);
            ITransportPlugin transportPlugin = (ITransportPlugin)ReflectionUtils.newInstance(transport_plugin_klassName);
            transportPlugin.prepare(type, topoConf, login_conf);
            return transportPlugin;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static IHttpCredentialsPlugin GetHttpCredentialsPlugin(Map<String, Object> conf, String klassName) {
        try {
            IHttpCredentialsPlugin plugin = null;
            if (StringUtils.isNotBlank((String)klassName)) {
                plugin = (IHttpCredentialsPlugin)ReflectionUtils.newInstance(klassName);
                plugin.prepare(conf);
            }
            return plugin;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static IHttpCredentialsPlugin GetUiHttpCredentialsPlugin(Map<String, Object> conf) {
        String klassName = (String)conf.get("ui.http.creds.plugin");
        return AuthUtils.GetHttpCredentialsPlugin(conf, klassName);
    }

    public static IHttpCredentialsPlugin GetDrpcHttpCredentialsPlugin(Map<String, Object> conf) {
        String klassName = (String)conf.get("drpc.http.creds.plugin");
        return klassName == null ? null : AuthUtils.GetHttpCredentialsPlugin(conf, klassName);
    }

    public static String makeDigestPayload(Configuration login_config, String config_section) {
        String username = null;
        String password = null;
        try {
            SortedMap<String, ?> results = AuthUtils.pullConfig(login_config, config_section);
            username = (String)results.get(USERNAME);
            password = (String)results.get(PASSWORD);
        }
        catch (Exception e) {
            LOG.error("Failed to pull username/password out of jaas conf", (Throwable)e);
        }
        if (username == null || password == null) {
            return null;
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-512");
            byte[] output = digest.digest((username + ":" + password).getBytes());
            return Hex.encodeHexString((byte[])output);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error("Cant run SHA-512 digest. Algorithm not available.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static byte[] serializeKerberosTicket(KerberosTicket tgt) throws Exception {
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bao);
        out.writeObject(tgt);
        out.flush();
        out.close();
        return bao.toByteArray();
    }

    public static KerberosTicket deserializeKerberosTicket(byte[] tgtBytes) {
        KerberosTicket ret;
        try {
            ByteArrayInputStream bin = new ByteArrayInputStream(tgtBytes);
            ObjectInputStream in = new ObjectInputStream(bin);
            ret = (KerberosTicket)in.readObject();
            in.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    public static KerberosTicket cloneKerberosTicket(KerberosTicket kerberosTicket) {
        if (kerberosTicket != null) {
            try {
                return AuthUtils.deserializeKerberosTicket(AuthUtils.serializeKerberosTicket(kerberosTicket));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to clone KerberosTicket TGT!!", e);
            }
        }
        return null;
    }
}

