/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth;

import com.google.common.annotations.VisibleForTesting;
import java.net.InetAddress;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.Subject;

public class ReqContext {
    private static final AtomicInteger uniqueId = new AtomicInteger(0);
    private Subject _subject;
    private InetAddress _remoteAddr;
    private Integer _reqID;
    private Principal realPrincipal;
    private static final ThreadLocal<ReqContext> ctxt = new ThreadLocal<ReqContext>(){

        @Override
        protected ReqContext initialValue() {
            return new ReqContext(AccessController.getContext());
        }
    };

    public String toString() {
        return "ReqContext{realPrincipal=" + (this.realPrincipal != null ? this.realPrincipal.getName() : "null") + ", _reqID=" + this._reqID + ", _remoteAddr=" + this._remoteAddr + ", _authZPrincipal=" + (this.principal() != null ? this.principal().getName() : "null") + ", ThreadId=" + Thread.currentThread().toString() + '}';
    }

    public static ReqContext context() {
        return ctxt.get();
    }

    public static void reset() {
        ctxt.remove();
    }

    @VisibleForTesting
    public ReqContext(AccessControlContext acl_ctxt) {
        this._subject = Subject.getSubject(acl_ctxt);
        this._reqID = uniqueId.incrementAndGet();
    }

    @VisibleForTesting
    public ReqContext(Subject sub) {
        this._subject = sub;
        this._reqID = uniqueId.incrementAndGet();
    }

    public void setRemoteAddress(InetAddress addr) {
        this._remoteAddr = addr;
    }

    public InetAddress remoteAddress() {
        return this._remoteAddr;
    }

    public void setSubject(Subject subject) {
        this._subject = subject;
    }

    public Subject subject() {
        return this._subject;
    }

    public Principal principal() {
        if (this._subject == null) {
            return null;
        }
        Set<Principal> princs = this._subject.getPrincipals();
        if (princs.size() == 0) {
            return null;
        }
        return (Principal)princs.toArray()[0];
    }

    public void setRealPrincipal(Principal realPrincipal) {
        this.realPrincipal = realPrincipal;
    }

    public Principal realPrincipal() {
        return this.realPrincipal;
    }

    public boolean isImpersonating() {
        return this.realPrincipal != null && !this.realPrincipal.equals(this.principal());
    }

    public Integer requestID() {
        return this._reqID;
    }
}

