/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.storm.security.auth.IGroupMappingServiceProvider;
import org.apache.storm.utils.ObjectReader;
import org.apache.storm.utils.ShellUtils;
import org.apache.storm.utils.TimeCacheMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellBasedGroupsMapping
implements IGroupMappingServiceProvider {
    public static final Logger LOG = LoggerFactory.getLogger(ShellBasedGroupsMapping.class);
    public TimeCacheMap<String, Set<String>> cachedGroups;

    @Override
    public void prepare(Map<String, Object> topoConf) {
        int timeout = ObjectReader.getInt(topoConf.get("storm.group.mapping.service.cache.duration.secs"));
        this.cachedGroups = new TimeCacheMap(timeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getGroups(String user) throws IOException {
        ShellBasedGroupsMapping shellBasedGroupsMapping = this;
        synchronized (shellBasedGroupsMapping) {
            if (this.cachedGroups.containsKey(user)) {
                return this.cachedGroups.get(user);
            }
        }
        Set<String> groups = ShellBasedGroupsMapping.getUnixGroups(user);
        if (!groups.isEmpty()) {
            ShellBasedGroupsMapping shellBasedGroupsMapping2 = this;
            synchronized (shellBasedGroupsMapping2) {
                this.cachedGroups.put(user, groups);
            }
        }
        return groups;
    }

    private static Set<String> getUnixGroups(String user) throws IOException {
        String result2;
        try {
            result2 = ShellUtils.execCommand(ShellUtils.getGroupsForUserCommand(user));
        }
        catch (ShellUtils.ExitCodeException e) {
            LOG.debug("unable to get groups for user " + user + ".ShellUtils command failed with exit code " + e.getExitCode());
            return new HashSet<String>();
        }
        StringTokenizer tokenizer = new StringTokenizer(result2, ShellUtils.TOKEN_SEPARATOR_REGEX);
        HashSet<String> groups = new HashSet<String>();
        while (tokenizer.hasMoreTokens()) {
            groups.add(tokenizer.nextToken());
        }
        return groups;
    }
}

