/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.auth;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import org.apache.storm.security.auth.ITransportPlugin;
import org.apache.storm.security.auth.ReqContext;
import org.apache.storm.security.auth.ThriftConnectionType;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.THsHaServer;
import org.apache.thrift.server.TServer;
import org.apache.thrift.transport.TFramedTransport;
import org.apache.thrift.transport.TMemoryInputTransport;
import org.apache.thrift.transport.TNonblockingServerSocket;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTransportPlugin
implements ITransportPlugin {
    protected ThriftConnectionType type;
    protected Map<String, Object> topoConf;
    protected Configuration login_conf;
    private static final Logger LOG = LoggerFactory.getLogger(SimpleTransportPlugin.class);
    private int port;

    @Override
    public void prepare(ThriftConnectionType type, Map<String, Object> topoConf, Configuration login_conf) {
        this.type = type;
        this.topoConf = topoConf;
        this.login_conf = login_conf;
    }

    @Override
    public TServer getServer(TProcessor processor) throws IOException, TTransportException {
        int configuredPort = this.type.getPort(this.topoConf);
        TNonblockingServerSocket serverTransport = new TNonblockingServerSocket(configuredPort);
        this.port = serverTransport.getPort();
        int numWorkerThreads = this.type.getNumThreads(this.topoConf);
        int maxBufferSize = this.type.getMaxBufferSize(this.topoConf);
        Integer queueSize = this.type.getQueueSize(this.topoConf);
        THsHaServer.Args server_args = (THsHaServer.Args)((THsHaServer.Args)new THsHaServer.Args((TNonblockingServerTransport)serverTransport).processor((TProcessor)new SimpleWrapProcessor(processor))).maxWorkerThreads(numWorkerThreads).protocolFactory((TProtocolFactory)new TBinaryProtocol.Factory(false, true, (long)maxBufferSize, -1L));
        server_args.maxReadBufferBytes = maxBufferSize;
        if (queueSize != null) {
            server_args.executorService((ExecutorService)new ThreadPoolExecutor(numWorkerThreads, numWorkerThreads, 60L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(queueSize)));
        }
        return new THsHaServer(server_args);
    }

    @Override
    public TTransport connect(TTransport transport, String serverHost, String asUser) throws TTransportException {
        int maxBufferSize = this.type.getMaxBufferSize(this.topoConf);
        TFramedTransport conn = new TFramedTransport(transport, maxBufferSize);
        conn.open();
        LOG.debug("Simple client transport has been established");
        return conn;
    }

    protected Subject getDefaultSubject() {
        return null;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    private class SimpleWrapProcessor
    implements TProcessor {
        final TProcessor wrapped;

        SimpleWrapProcessor(TProcessor wrapped) {
            this.wrapped = wrapped;
        }

        public boolean process(TProtocol inProt, TProtocol outProt) throws TException {
            String user;
            ReqContext req_context = ReqContext.context();
            TTransport trans = inProt.getTransport();
            if (trans instanceof TMemoryInputTransport) {
                try {
                    req_context.setRemoteAddress(InetAddress.getLocalHost());
                }
                catch (UnknownHostException e) {
                    throw new RuntimeException(e);
                }
            } else if (trans instanceof TSocket) {
                TSocket tsocket = (TSocket)trans;
                Socket socket = tsocket.getSocket();
                req_context.setRemoteAddress(socket.getInetAddress());
            }
            Subject s = SimpleTransportPlugin.this.getDefaultSubject();
            if (s == null && (user = (String)SimpleTransportPlugin.this.topoConf.get("debug.simple.transport.user")) != null) {
                HashSet<1> principals = new HashSet<1>();
                principals.add(new Principal(){

                    @Override
                    public String getName() {
                        return user;
                    }

                    @Override
                    public String toString() {
                        return user;
                    }
                });
                s = new Subject(true, principals, new HashSet(), new HashSet());
            }
            req_context.setSubject(s);
            return this.wrapped.process(inProt, outProt);
        }
    }
}

