/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.security.serialization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.BlowfishSerializer;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.storm.serialization.types.ListDelegateSerializer;
import org.apache.storm.utils.ListDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlowfishTupleSerializer
extends Serializer<ListDelegate> {
    public static final String SECRET_KEY = "topology.tuple.serializer.blowfish.key";
    private static final Logger LOG = LoggerFactory.getLogger(BlowfishTupleSerializer.class);
    private BlowfishSerializer _serializer;

    public BlowfishTupleSerializer(Kryo kryo, Map<String, Object> topoConf) {
        try {
            String encryption_key = (String)topoConf.get(SECRET_KEY);
            LOG.debug("Blowfish serializer being constructed ...");
            if (encryption_key == null) {
                throw new RuntimeException("Blowfish encryption key not specified");
            }
            byte[] bytes = Hex.decodeHex((char[])encryption_key.toCharArray());
            this._serializer = new BlowfishSerializer((Serializer)new ListDelegateSerializer(), bytes);
        }
        catch (DecoderException ex) {
            throw new RuntimeException("Blowfish encryption key invalid", ex);
        }
    }

    public void write(Kryo kryo, Output output, ListDelegate object) {
        kryo.writeObject(output, (Object)object, (Serializer)this._serializer);
    }

    public ListDelegate read(Kryo kryo, Input input, Class<ListDelegate> type) {
        return (ListDelegate)kryo.readObject(input, ListDelegate.class, (Serializer)this._serializer);
    }

    public static void main(String[] args) {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("Blowfish");
            SecretKey skey = kgen.generateKey();
            byte[] raw = skey.getEncoded();
            String keyString = new String(Hex.encodeHex((byte[])raw));
            System.out.println("storm -c topology.tuple.serializer.blowfish.key=" + keyString + " -c " + "topology.tuple.serializer" + "=" + BlowfishTupleSerializer.class.getName() + " ...");
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage());
            ex.printStackTrace();
        }
    }
}

