/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.stats;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.storm.generated.BoltStats;
import org.apache.storm.generated.ExecutorSpecificStats;
import org.apache.storm.generated.ExecutorStats;
import org.apache.storm.metric.internal.MultiCountStatAndMetric;
import org.apache.storm.metric.internal.MultiLatencyStatAndMetric;
import org.apache.storm.stats.CommonStats;
import org.apache.storm.stats.StatsUtil;

public class BoltExecutorStats
extends CommonStats {
    public static final String ACKED = "acked";
    public static final String FAILED = "failed";
    public static final String EXECUTED = "executed";
    public static final String PROCESS_LATENCIES = "process-latencies";
    public static final String EXECUTE_LATENCIES = "execute-latencies";

    public BoltExecutorStats(int rate, int numStatBuckets) {
        super(rate, numStatBuckets);
        this.put(ACKED, new MultiCountStatAndMetric(numStatBuckets));
        this.put(FAILED, new MultiCountStatAndMetric(numStatBuckets));
        this.put(EXECUTED, new MultiCountStatAndMetric(numStatBuckets));
        this.put(PROCESS_LATENCIES, new MultiLatencyStatAndMetric(numStatBuckets));
        this.put(EXECUTE_LATENCIES, new MultiLatencyStatAndMetric(numStatBuckets));
    }

    public MultiCountStatAndMetric getAcked() {
        return (MultiCountStatAndMetric)this.get(ACKED);
    }

    public MultiCountStatAndMetric getFailed() {
        return (MultiCountStatAndMetric)this.get(FAILED);
    }

    public MultiCountStatAndMetric getExecuted() {
        return (MultiCountStatAndMetric)this.get(EXECUTED);
    }

    public MultiLatencyStatAndMetric getProcessLatencies() {
        return (MultiLatencyStatAndMetric)this.get(PROCESS_LATENCIES);
    }

    public MultiLatencyStatAndMetric getExecuteLatencies() {
        return (MultiLatencyStatAndMetric)this.get(EXECUTE_LATENCIES);
    }

    public void boltExecuteTuple(String component, String stream, long latencyMs) {
        ArrayList key = Lists.newArrayList((Object[])new String[]{component, stream});
        this.getExecuted().incBy(key, this.rate);
        this.getExecuteLatencies().record(key, latencyMs);
    }

    public void boltAckedTuple(String component, String stream, long latencyMs) {
        ArrayList key = Lists.newArrayList((Object[])new String[]{component, stream});
        this.getAcked().incBy(key, this.rate);
        this.getProcessLatencies().record(key, latencyMs);
    }

    public void boltFailedTuple(String component, String stream, long latencyMs) {
        ArrayList key = Lists.newArrayList((Object[])new String[]{component, stream});
        this.getFailed().incBy(key, this.rate);
    }

    @Override
    public ExecutorStats renderStats() {
        ExecutorStats ret = new ExecutorStats();
        ret.set_emitted(this.valueStat("emitted"));
        ret.set_transferred(this.valueStat("transferred"));
        ret.set_rate(this.rate);
        BoltStats boltStats = new BoltStats(StatsUtil.windowSetConverter(this.valueStat(ACKED), StatsUtil.TO_GSID, StatsUtil.IDENTITY), StatsUtil.windowSetConverter(this.valueStat(FAILED), StatsUtil.TO_GSID, StatsUtil.IDENTITY), StatsUtil.windowSetConverter(this.valueStat(PROCESS_LATENCIES), StatsUtil.TO_GSID, StatsUtil.IDENTITY), StatsUtil.windowSetConverter(this.valueStat(EXECUTED), StatsUtil.TO_GSID, StatsUtil.IDENTITY), StatsUtil.windowSetConverter(this.valueStat(EXECUTE_LATENCIES), StatsUtil.TO_GSID, StatsUtil.IDENTITY));
        ret.set_specific(ExecutorSpecificStats.bolt(boltStats));
        return ret;
    }
}

