/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.stats;

import java.util.HashMap;
import java.util.Map;
import org.apache.storm.generated.ExecutorStats;
import org.apache.storm.metric.api.IMetric;
import org.apache.storm.metric.internal.MultiCountStatAndMetric;
import org.apache.storm.metric.internal.MultiLatencyStatAndMetric;
import org.apache.storm.stats.StatsUtil;

public abstract class CommonStats {
    public static final String RATE = "rate";
    public static final String EMITTED = "emitted";
    public static final String TRANSFERRED = "transferred";
    public static final String[] COMMON_FIELDS = new String[]{"emitted", "transferred"};
    protected final int rate;
    protected final Map<String, IMetric> metricMap = new HashMap<String, IMetric>();

    public CommonStats(int rate, int numStatBuckets) {
        this.rate = rate;
        this.put(EMITTED, new MultiCountStatAndMetric(numStatBuckets));
        this.put(TRANSFERRED, new MultiCountStatAndMetric(numStatBuckets));
    }

    public int getRate() {
        return this.rate;
    }

    public MultiCountStatAndMetric getEmitted() {
        return (MultiCountStatAndMetric)this.get(EMITTED);
    }

    public MultiCountStatAndMetric getTransferred() {
        return (MultiCountStatAndMetric)this.get(TRANSFERRED);
    }

    public IMetric get(String field) {
        return (IMetric)StatsUtil.getByKey(this.metricMap, field);
    }

    protected void put(String field, Object value) {
        StatsUtil.putKV(this.metricMap, field, value);
    }

    public void emittedTuple(String stream) {
        this.getEmitted().incBy(stream, this.rate);
    }

    public void transferredTuples(String stream, int amount) {
        this.getTransferred().incBy(stream, this.rate * amount);
    }

    public void cleanupStats() {
        for (IMetric imetric : this.metricMap.values()) {
            this.cleanupStat(imetric);
        }
    }

    private void cleanupStat(IMetric metric) {
        if (metric instanceof MultiCountStatAndMetric) {
            ((MultiCountStatAndMetric)metric).close();
        } else if (metric instanceof MultiLatencyStatAndMetric) {
            ((MultiLatencyStatAndMetric)metric).close();
        }
    }

    protected Map valueStats(String[] fields) {
        HashMap ret = new HashMap();
        for (String field : fields) {
            IMetric metric = this.get(field);
            if (metric instanceof MultiCountStatAndMetric) {
                StatsUtil.putKV(ret, field, ((MultiCountStatAndMetric)metric).getTimeCounts());
                continue;
            }
            if (!(metric instanceof MultiLatencyStatAndMetric)) continue;
            StatsUtil.putKV(ret, field, ((MultiLatencyStatAndMetric)metric).getTimeLatAvg());
        }
        StatsUtil.putKV(ret, RATE, this.getRate());
        return ret;
    }

    protected Map valueStat(String field) {
        IMetric metric = this.get(field);
        if (metric instanceof MultiCountStatAndMetric) {
            return ((MultiCountStatAndMetric)metric).getTimeCounts();
        }
        if (metric instanceof MultiLatencyStatAndMetric) {
            return ((MultiLatencyStatAndMetric)metric).getTimeLatAvg();
        }
        return null;
    }

    public abstract ExecutorStats renderStats();
}

