/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.stats;

import org.apache.storm.generated.ExecutorSpecificStats;
import org.apache.storm.generated.ExecutorStats;
import org.apache.storm.generated.SpoutStats;
import org.apache.storm.metric.internal.MultiCountStatAndMetric;
import org.apache.storm.metric.internal.MultiLatencyStatAndMetric;
import org.apache.storm.stats.CommonStats;

public class SpoutExecutorStats
extends CommonStats {
    public static final String ACKED = "acked";
    public static final String FAILED = "failed";
    public static final String COMPLETE_LATENCIES = "complete-latencies";

    public SpoutExecutorStats(int rate, int numStatBuckets) {
        super(rate, numStatBuckets);
        this.put(ACKED, new MultiCountStatAndMetric(numStatBuckets));
        this.put(FAILED, new MultiCountStatAndMetric(numStatBuckets));
        this.put(COMPLETE_LATENCIES, new MultiLatencyStatAndMetric(numStatBuckets));
    }

    public MultiCountStatAndMetric getAcked() {
        return (MultiCountStatAndMetric)this.get(ACKED);
    }

    public MultiCountStatAndMetric getFailed() {
        return (MultiCountStatAndMetric)this.get(FAILED);
    }

    public MultiLatencyStatAndMetric getCompleteLatencies() {
        return (MultiLatencyStatAndMetric)this.get(COMPLETE_LATENCIES);
    }

    public void spoutAckedTuple(String stream, long latencyMs) {
        this.getAcked().incBy(stream, this.rate);
        this.getCompleteLatencies().record(stream, latencyMs);
    }

    public void spoutFailedTuple(String stream, long latencyMs) {
        this.getFailed().incBy(stream, this.rate);
    }

    @Override
    public ExecutorStats renderStats() {
        ExecutorStats ret = new ExecutorStats();
        ret.set_emitted(this.valueStat("emitted"));
        ret.set_transferred(this.valueStat("transferred"));
        ret.set_rate(this.rate);
        SpoutStats spoutStats = new SpoutStats(this.valueStat(ACKED), this.valueStat(FAILED), this.valueStat(COMPLETE_LATENCIES));
        ret.set_specific(ExecutorSpecificStats.spout(spoutStats));
        return ret;
    }
}

