/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.streams;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.storm.streams.Node;
import org.apache.storm.streams.processors.BatchProcessor;
import org.apache.storm.streams.processors.Processor;
import org.apache.storm.streams.processors.ProcessorContext;
import org.apache.storm.tuple.Fields;

public class ProcessorNode
extends Node {
    private final Processor<?> processor;
    private final boolean isBatch;
    private final boolean preservesKey;
    private Set<String> windowedParentStreams = Collections.emptySet();

    public ProcessorNode(Processor<?> processor, String outputStream, Fields outputFields, boolean preservesKey) {
        super(outputStream, outputFields);
        this.isBatch = processor instanceof BatchProcessor;
        this.processor = processor;
        this.preservesKey = preservesKey;
    }

    public ProcessorNode(Processor<?> processor, String outputStream, Fields outputFields) {
        this(processor, outputStream, outputFields, false);
    }

    public Processor<?> getProcessor() {
        return this.processor;
    }

    public boolean isBatch() {
        return this.isBatch;
    }

    public Set<String> getWindowedParentStreams() {
        return Collections.unmodifiableSet(this.windowedParentStreams);
    }

    void initProcessorContext(ProcessorContext context) {
        this.processor.init(context);
    }

    void setWindowedParentStreams(Set<String> windowedParentStreams) {
        this.windowedParentStreams = new HashSet<String>(windowedParentStreams);
    }

    public boolean isPreservesKey() {
        return this.preservesKey;
    }

    @Override
    public String toString() {
        return "ProcessorNode{processor=" + this.processor + ", isBatch=" + this.isBatch + ", preservesKey=" + this.preservesKey + ", windowedParentStreams=" + this.windowedParentStreams + "} " + super.toString();
    }
}

