/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang.NotImplementedException;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.generated.Grouping;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.hooks.ITaskHook;
import org.apache.storm.metric.api.CombinedMetric;
import org.apache.storm.metric.api.ICombiner;
import org.apache.storm.metric.api.IMetric;
import org.apache.storm.metric.api.IReducer;
import org.apache.storm.metric.api.ReducedMetric;
import org.apache.storm.state.ISubscribedState;
import org.apache.storm.task.IMetricsContext;
import org.apache.storm.task.WorkerTopologyContext;
import org.apache.storm.tuple.Fields;
import org.json.simple.JSONValue;

public class TopologyContext
extends WorkerTopologyContext
implements IMetricsContext {
    private Integer _taskId;
    private Map<String, Object> _taskData = new HashMap<String, Object>();
    private List<ITaskHook> _hooks = new ArrayList<ITaskHook>();
    private Map<String, Object> _executorData;
    private Map<Integer, Map<Integer, Map<String, IMetric>>> _registeredMetrics;
    private AtomicBoolean _openOrPrepareWasCalled;

    public TopologyContext(StormTopology topology, Map<String, Object> topoConf, Map<Integer, String> taskToComponent, Map<String, List<Integer>> componentToSortedTasks, Map<String, Map<String, Fields>> componentToStreamToFields, String stormId, String codeDir, String pidDir, Integer taskId, Integer workerPort, List<Integer> workerTasks, Map<String, Object> defaultResources, Map<String, Object> userResources, Map<String, Object> executorData, Map<Integer, Map<Integer, Map<String, IMetric>>> registeredMetrics, AtomicBoolean openOrPrepareWasCalled) {
        super(topology, topoConf, taskToComponent, componentToSortedTasks, componentToStreamToFields, stormId, codeDir, pidDir, workerPort, workerTasks, defaultResources, userResources);
        this._taskId = taskId;
        this._executorData = executorData;
        this._registeredMetrics = registeredMetrics;
        this._openOrPrepareWasCalled = openOrPrepareWasCalled;
    }

    public <T extends ISubscribedState> T setAllSubscribedState(T obj) {
        throw new NotImplementedException();
    }

    public <T extends ISubscribedState> T setSubscribedState(String componentId, T obj) {
        return this.setSubscribedState(componentId, "default", obj);
    }

    public <T extends ISubscribedState> T setSubscribedState(String componentId, String streamId, T obj) {
        throw new NotImplementedException();
    }

    public int getThisTaskId() {
        return this._taskId;
    }

    public String getThisComponentId() {
        return this.getComponentId(this._taskId);
    }

    public Fields getThisOutputFields(String streamId) {
        return this.getComponentOutputFields(this.getThisComponentId(), streamId);
    }

    public Map<String, List<String>> getThisOutputFieldsForStreams() {
        HashMap<String, List<String>> streamToFields = new HashMap<String, List<String>>();
        for (String stream : this.getThisStreams()) {
            streamToFields.put(stream, this.getThisOutputFields(stream).toList());
        }
        return streamToFields;
    }

    public Set<String> getThisStreams() {
        return this.getComponentStreams(this.getThisComponentId());
    }

    public int getThisTaskIndex() {
        ArrayList<Integer> tasks = new ArrayList<Integer>(this.getComponentTasks(this.getThisComponentId()));
        Collections.sort(tasks);
        for (int i = 0; i < tasks.size(); ++i) {
            if (((Integer)tasks.get(i)).intValue() != this.getThisTaskId()) continue;
            return i;
        }
        throw new RuntimeException("Fatal: could not find this task id in this component");
    }

    public Map<String, Map<String, List<String>>> getThisInputFields() {
        HashMap<String, Map<String, List<String>>> outputMap = new HashMap<String, Map<String, List<String>>>();
        for (Map.Entry<GlobalStreamId, Grouping> entry : this.getThisSources().entrySet()) {
            String componentId = entry.getKey().get_componentId();
            Set<String> streams = this.getComponentStreams(componentId);
            for (String stream : streams) {
                HashMap<String, List<String>> streamFieldMap = (HashMap<String, List<String>>)outputMap.get(componentId);
                if (streamFieldMap == null) {
                    streamFieldMap = new HashMap<String, List<String>>();
                    outputMap.put(componentId, streamFieldMap);
                }
                streamFieldMap.put(stream, this.getComponentOutputFields(componentId, stream).toList());
            }
        }
        return outputMap;
    }

    public Map<GlobalStreamId, Grouping> getThisSources() {
        return this.getSources(this.getThisComponentId());
    }

    public Map<String, Map<String, Grouping>> getThisTargets() {
        return this.getTargets(this.getThisComponentId());
    }

    public void setTaskData(String name, Object data) {
        this._taskData.put(name, data);
    }

    public Object getTaskData(String name) {
        return this._taskData.get(name);
    }

    public void setExecutorData(String name, Object data) {
        this._executorData.put(name, data);
    }

    public Object getExecutorData(String name) {
        return this._executorData.get(name);
    }

    public void addTaskHook(ITaskHook hook) {
        hook.prepare(this._topoConf, this);
        this._hooks.add(hook);
    }

    public Collection<ITaskHook> getHooks() {
        return this._hooks;
    }

    private static Map<String, Object> groupingToJSONableMap(Grouping grouping) {
        HashMap<String, Object> groupingMap = new HashMap<String, Object>();
        groupingMap.put("type", ((Grouping._Fields)grouping.getSetField()).toString());
        if (grouping.is_set_fields()) {
            groupingMap.put("fields", grouping.get_fields());
        }
        return groupingMap;
    }

    @Override
    public String toJSONString() {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        obj.put("task->component", this.getTaskToComponent());
        obj.put("taskid", this.getThisTaskId());
        obj.put("componentid", this.getThisComponentId());
        ArrayList<String> streamList = new ArrayList<String>();
        streamList.addAll(this.getThisStreams());
        obj.put("streams", streamList);
        obj.put("stream->outputfields", this.getThisOutputFieldsForStreams());
        HashMap stringTargets = new HashMap();
        for (Map.Entry<String, Map<String, Grouping>> entry : this.getThisTargets().entrySet()) {
            HashMap<String, Map<String, Object>> stringTargetMap = new HashMap<String, Map<String, Object>>();
            for (Map.Entry<String, Grouping> innerEntry : entry.getValue().entrySet()) {
                stringTargetMap.put(innerEntry.getKey(), TopologyContext.groupingToJSONableMap(innerEntry.getValue()));
            }
            stringTargets.put(entry.getKey(), stringTargetMap);
        }
        obj.put("stream->target->grouping", stringTargets);
        HashMap<String, HashMap<String, Map<String, Object>>> stringSources = new HashMap<String, HashMap<String, Map<String, Object>>>();
        for (Map.Entry<GlobalStreamId, Grouping> entry : this.getThisSources().entrySet()) {
            GlobalStreamId gid = entry.getKey();
            HashMap<String, Map<String, Object>> stringSourceMap = (HashMap<String, Map<String, Object>>)stringSources.get(gid.get_componentId());
            if (stringSourceMap == null) {
                stringSourceMap = new HashMap<String, Map<String, Object>>();
                stringSources.put(gid.get_componentId(), stringSourceMap);
            }
            stringSourceMap.put(gid.get_streamId(), TopologyContext.groupingToJSONableMap(entry.getValue()));
        }
        obj.put("source->stream->grouping", stringSources);
        obj.put("source->stream->fields", this.getThisInputFields());
        return JSONValue.toJSONString(obj);
    }

    @Override
    public <T extends IMetric> T registerMetric(String name, T metric, int timeBucketSizeInSecs) {
        Map<String, IMetric> m3;
        Map<Integer, Map<String, IMetric>> m2;
        if (this._openOrPrepareWasCalled.get()) {
            throw new RuntimeException("TopologyContext.registerMetric can only be called from within overridden IBolt::prepare() or ISpout::open() method.");
        }
        if (metric == null) {
            throw new IllegalArgumentException("Cannot register a null metric");
        }
        if (timeBucketSizeInSecs <= 0) {
            throw new IllegalArgumentException("TopologyContext.registerMetric can only be called with timeBucketSizeInSecs greater than or equal to 1 second.");
        }
        if (this.getRegisteredMetricByName(name) != null) {
            throw new RuntimeException("The same metric name `" + name + "` was registered twice.");
        }
        Map<Integer, Map<Integer, Map<String, IMetric>>> m1 = this._registeredMetrics;
        if (!m1.containsKey(timeBucketSizeInSecs)) {
            m1.put(timeBucketSizeInSecs, new HashMap());
        }
        if (!(m2 = m1.get(timeBucketSizeInSecs)).containsKey(this._taskId)) {
            m2.put(this._taskId, new HashMap());
        }
        if ((m3 = m2.get(this._taskId)).containsKey(name)) {
            throw new RuntimeException("The same metric name `" + name + "` was registered twice.");
        }
        m3.put(name, metric);
        return metric;
    }

    public IMetric getRegisteredMetricByName(String name) {
        Map<Integer, Map<String, IMetric>> taskIdToNameToMetric;
        Map<String, IMetric> nameToMetric;
        IMetric metric = null;
        Iterator<Map<Integer, Map<String, IMetric>>> iterator = this._registeredMetrics.values().iterator();
        while (iterator.hasNext() && ((nameToMetric = (taskIdToNameToMetric = iterator.next()).get(this._taskId)) == null || (metric = nameToMetric.get(name)) == null)) {
        }
        return metric;
    }

    @Override
    public ReducedMetric registerMetric(String name, IReducer reducer, int timeBucketSizeInSecs) {
        return this.registerMetric(name, new ReducedMetric(reducer), timeBucketSizeInSecs);
    }

    @Override
    public CombinedMetric registerMetric(String name, ICombiner combiner, int timeBucketSizeInSecs) {
        return this.registerMetric(name, new CombinedMetric(combiner), timeBucketSizeInSecs);
    }
}

