/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.testing;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.testing.AckFailDelegate;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseRichSpout;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Values;
import org.apache.storm.utils.InprocMessaging;

public class FeederSpout
extends BaseRichSpout {
    private int _id = InprocMessaging.acquireNewPort();
    private Fields _outFields;
    private SpoutOutputCollector _collector;
    private AckFailDelegate _ackFailDelegate;

    public FeederSpout(List<String> outFields) {
        this(new Fields(outFields));
    }

    public FeederSpout(Fields outFields) {
        this._outFields = outFields;
    }

    public void setAckFailDelegate(AckFailDelegate d) {
        this._ackFailDelegate = d;
    }

    public void feed(List<Object> tuple) {
        this.feed(tuple, UUID.randomUUID().toString());
    }

    public void feed(List<Object> tuple, Object msgId) {
        InprocMessaging.sendMessage(this._id, new Values(tuple, msgId));
    }

    public void feedNoWait(List<Object> tuple, Object msgId) {
        InprocMessaging.sendMessageNoWait(this._id, new Values(tuple, msgId));
    }

    public void waitForReader() {
        InprocMessaging.waitForReader(this._id);
    }

    @Override
    public void open(Map<String, Object> conf, TopologyContext context, SpoutOutputCollector collector) {
        this._collector = collector;
    }

    @Override
    public void close() {
    }

    @Override
    public void nextTuple() {
        List toEmit = (List)InprocMessaging.pollMessage(this._id);
        if (toEmit != null) {
            List tuple = (List)toEmit.get(0);
            Object msgId = toEmit.get(1);
            this._collector.emit(tuple, msgId);
        }
    }

    @Override
    public void ack(Object msgId) {
        if (this._ackFailDelegate != null) {
            this._ackFailDelegate.ack(msgId);
        }
    }

    @Override
    public void fail(Object msgId) {
        if (this._ackFailDelegate != null) {
            this._ackFailDelegate.fail(msgId);
        }
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(this._outFields);
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return new HashMap<String, Object>();
    }
}

