/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.testing;

import java.util.HashMap;
import java.util.Map;
import org.apache.storm.coordination.BatchOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseBatchBolt;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.tuple.Values;
import org.apache.storm.utils.Utils;

public class KeyedSummingBatchBolt
extends BaseBatchBolt<Object> {
    BatchOutputCollector _collector;
    Object _id;
    Map<Object, Number> _sums = new HashMap<Object, Number>();

    @Override
    public void prepare(Map<String, Object> conf, TopologyContext context, BatchOutputCollector collector, Object id) {
        this._collector = collector;
        this._id = id;
    }

    @Override
    public void execute(Tuple tuple) {
        Object key = tuple.getValue(1);
        Number curr = Utils.get(this._sums, key, 0);
        this._sums.put(key, curr.longValue() + ((Number)tuple.getValue(2)).longValue());
    }

    @Override
    public void finishBatch() {
        for (Object key : this._sums.keySet()) {
            this._collector.emit(new Values(this._id, key, this._sums.get(key)));
        }
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(new Fields("tx", "key", "sum"));
    }
}

