/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.testing;

import java.util.HashMap;
import java.util.Map;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.testing.TestWordCounter;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseRichBolt;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Tuple;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestAggregatesCounter
extends BaseRichBolt {
    public static Logger LOG = LoggerFactory.getLogger(TestWordCounter.class);
    Map<String, Integer> _counts;
    OutputCollector _collector;

    @Override
    public void prepare(Map<String, Object> topoConf, TopologyContext context, OutputCollector collector) {
        this._collector = collector;
        this._counts = new HashMap<String, Integer>();
    }

    @Override
    public void execute(Tuple input) {
        String word = (String)input.getValues().get(0);
        int count = (Integer)input.getValues().get(1);
        this._counts.put(word, count);
        int globalCount = 0;
        for (String w : this._counts.keySet()) {
            globalCount += this._counts.get(w).intValue();
        }
        this._collector.emit(Utils.tuple(globalCount));
        this._collector.ack(input);
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(new Fields("agg-global"));
    }
}

