/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.testing;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.storm.spout.SpoutOutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.testing.CompletableSpout;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.base.BaseRichSpout;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Values;
import org.apache.storm.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestEventLogSpout
extends BaseRichSpout
implements CompletableSpout {
    public static Logger LOG = LoggerFactory.getLogger(TestEventLogSpout.class);
    private static final Map<String, Integer> acked = new HashMap<String, Integer>();
    private static final Map<String, Integer> failed = new HashMap<String, Integer>();
    private String uid = UUID.randomUUID().toString();
    private long totalCount;
    SpoutOutputCollector _collector;
    private long eventId = 0L;
    private long myCount;
    private int source;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNumAcked(String stormId) {
        Map<String, Integer> map = acked;
        synchronized (map) {
            return Utils.get(acked, stormId, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNumFailed(String stormId) {
        Map<String, Integer> map = failed;
        synchronized (map) {
            return Utils.get(failed, stormId, 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TestEventLogSpout(long totalCount) {
        Map<String, Integer> map = acked;
        synchronized (map) {
            acked.put(this.uid, 0);
        }
        map = failed;
        synchronized (map) {
            failed.put(this.uid, 0);
        }
        this.totalCount = totalCount;
    }

    @Override
    public void open(Map<String, Object> conf, TopologyContext context, SpoutOutputCollector collector) {
        this._collector = collector;
        this.source = context.getThisTaskId();
        long taskCount = context.getComponentTasks(context.getThisComponentId()).size();
        this.myCount = this.totalCount / taskCount;
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        Map<String, Integer> map = acked;
        synchronized (map) {
            acked.remove(this.uid);
        }
        map = failed;
        synchronized (map) {
            failed.remove(this.uid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean completed() {
        int failedAmt;
        int ackedAmt;
        Map<String, Integer> map = acked;
        synchronized (map) {
            ackedAmt = acked.get(this.uid);
        }
        map = failed;
        synchronized (map) {
            failedAmt = failed.get(this.uid);
        }
        int totalEmitted = ackedAmt + failedAmt;
        return (long)totalEmitted >= this.totalCount;
    }

    @Override
    public void nextTuple() {
        if (this.eventId < this.myCount) {
            ++this.eventId;
            this._collector.emit(new Values(this.source, this.eventId), this.eventId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void ack(Object msgId) {
        Map<String, Integer> map = acked;
        synchronized (map) {
            int curr = Utils.get(acked, this.uid, 0);
            acked.put(this.uid, curr + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fail(Object msgId) {
        Map<String, Integer> map = failed;
        synchronized (map) {
            int curr = Utils.get(failed, this.uid, 0);
            failed.put(this.uid, curr + 1);
        }
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        declarer.declare(new Fields("source", "eventId"));
    }

    @Override
    public boolean isExhausted() {
        return this.completed();
    }
}

