/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.topology;

import java.util.Map;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.BasicOutputCollector;
import org.apache.storm.topology.FailedException;
import org.apache.storm.topology.IBasicBolt;
import org.apache.storm.topology.IRichBolt;
import org.apache.storm.topology.OutputFieldsDeclarer;
import org.apache.storm.topology.ReportedFailedException;
import org.apache.storm.tuple.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicBoltExecutor
implements IRichBolt {
    public static final Logger LOG = LoggerFactory.getLogger(BasicBoltExecutor.class);
    private IBasicBolt _bolt;
    private transient BasicOutputCollector _collector;

    public BasicBoltExecutor(IBasicBolt bolt) {
        this._bolt = bolt;
    }

    @Override
    public void declareOutputFields(OutputFieldsDeclarer declarer) {
        this._bolt.declareOutputFields(declarer);
    }

    @Override
    public void prepare(Map<String, Object> topoConf, TopologyContext context, OutputCollector collector) {
        this._bolt.prepare(topoConf, context);
        this._collector = new BasicOutputCollector(collector);
    }

    @Override
    public void execute(Tuple input) {
        this._collector.setContext(input);
        try {
            this._bolt.execute(input, this._collector);
            this._collector.getOutputter().ack(input);
        }
        catch (FailedException e) {
            if (e instanceof ReportedFailedException) {
                this._collector.reportError(e);
            }
            this._collector.getOutputter().fail(input);
        }
    }

    @Override
    public void cleanup() {
        this._bolt.cleanup();
    }

    @Override
    public Map<String, Object> getComponentConfiguration() {
        return this._bolt.getComponentConfiguration();
    }
}

