/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.topology;

import org.apache.storm.tuple.Tuple;
import org.apache.storm.windowing.TimestampExtractor;

public final class TupleFieldTimestampExtractor
implements TimestampExtractor {
    private final String fieldName;

    private TupleFieldTimestampExtractor(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public long extractTimestamp(Tuple tuple) {
        return tuple.getLongByField(this.fieldName);
    }

    public static TupleFieldTimestampExtractor of(String fieldName) {
        return new TupleFieldTimestampExtractor(fieldName);
    }

    public String toString() {
        return "TupleFieldTimestampExtractor{fieldName='" + this.fieldName + '\'' + '}';
    }
}

