/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.transactional.state;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.PathAndBytesable;
import org.apache.curator.framework.api.ProtectACLCreateModePathAndBytesable;
import org.apache.storm.serialization.KryoValuesDeserializer;
import org.apache.storm.serialization.KryoValuesSerializer;
import org.apache.storm.utils.CuratorUtils;
import org.apache.storm.utils.Utils;
import org.apache.storm.utils.ZookeeperAuthInfo;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.ACL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalState {
    public static final Logger LOG = LoggerFactory.getLogger(TransactionalState.class);
    CuratorFramework _curator;
    KryoValuesSerializer _ser;
    KryoValuesDeserializer _des;
    List<ACL> _zkAcls = null;

    public static TransactionalState newUserState(Map<String, Object> conf, String id, Map componentConf) {
        return new TransactionalState(conf, id, componentConf, "user");
    }

    public static TransactionalState newCoordinatorState(Map<String, Object> conf, String id, Map componentConf) {
        return new TransactionalState(conf, id, componentConf, "coordinator");
    }

    protected TransactionalState(Map<String, Object> conf, String id, Map componentConf, String subroot) {
        try {
            conf = new HashMap<String, Object>(conf);
            if (componentConf != null) {
                conf.put("topology.kryo.register", componentConf.get("topology.kryo.register"));
            }
            String transactionalRoot = (String)conf.get("transactional.zookeeper.root");
            String rootDir = transactionalRoot + "/" + id + "/" + subroot;
            List servers = (List)this.getWithBackup(conf, "transactional.zookeeper.servers", "storm.zookeeper.servers");
            Object port = this.getWithBackup(conf, "transactional.zookeeper.port", "storm.zookeeper.port");
            ZookeeperAuthInfo auth = new ZookeeperAuthInfo(conf);
            CuratorFramework initter = CuratorUtils.newCuratorStarted(conf, servers, port, auth);
            this._zkAcls = Utils.getWorkerACL(conf);
            try {
                TransactionalState.createNode(initter, transactionalRoot, null, null, null);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                // empty catch block
            }
            try {
                TransactionalState.createNode(initter, rootDir, null, this._zkAcls, null);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                // empty catch block
            }
            initter.close();
            this._curator = CuratorUtils.newCuratorStarted(conf, servers, port, rootDir, auth);
            this._ser = new KryoValuesSerializer(conf);
            this._des = new KryoValuesDeserializer(conf);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static void forPath(PathAndBytesable<String> builder, String path, byte[] data) throws Exception {
        try {
            if (data == null) {
                builder.forPath(path);
            } else {
                builder.forPath(path, data);
            }
        }
        catch (KeeperException.NodeExistsException e) {
            LOG.info("Path {} already exists.", (Object)path);
        }
    }

    protected static void createNode(CuratorFramework curator, String path, byte[] data, List<ACL> acls, CreateMode mode) throws Exception {
        ProtectACLCreateModePathAndBytesable builder = curator.create().creatingParentsIfNeeded();
        if (acls == null) {
            if (mode == null) {
                TransactionalState.forPath((PathAndBytesable<String>)builder, path, data);
            } else {
                TransactionalState.forPath((PathAndBytesable<String>)((PathAndBytesable)builder.withMode(mode)), path, data);
            }
            return;
        }
        TransactionalState.forPath((PathAndBytesable<String>)((PathAndBytesable)builder.withACL(acls)), path, data);
    }

    public void setData(String path, Object obj) {
        path = "/" + path;
        byte[] ser = this._ser.serializeObject(obj);
        try {
            if (this._curator.checkExists().forPath(path) != null) {
                this._curator.setData().forPath(path, ser);
            } else {
                TransactionalState.createNode(this._curator, path, ser, this._zkAcls, CreateMode.PERSISTENT);
            }
        }
        catch (KeeperException.NodeExistsException nee) {
            LOG.warn("Path {} already exists.", (Object)path);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void delete(String path) {
        path = "/" + path;
        try {
            this._curator.delete().forPath(path);
        }
        catch (KeeperException.NoNodeException nne) {
            LOG.info("Path {} has already been deleted.", (Object)path);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> list(String path) {
        path = "/" + path;
        try {
            if (this._curator.checkExists().forPath(path) == null) {
                return new ArrayList<String>();
            }
            return (List)this._curator.getChildren().forPath(path);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void mkdir(String path) {
        this.setData(path, 7);
    }

    public Object getData(String path) {
        path = "/" + path;
        try {
            if (this._curator.checkExists().forPath(path) != null) {
                return this._des.deserializeObject((byte[])this._curator.getData().forPath(path));
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        this._curator.close();
    }

    private Object getWithBackup(Map amap, Object primary, Object backup) {
        Object ret = amap.get(primary);
        if (ret == null) {
            return amap.get(backup);
        }
        return ret;
    }
}

