/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.fluent;

import org.apache.storm.trident.Stream;
import org.apache.storm.trident.TridentState;
import org.apache.storm.trident.fluent.ChainedAggregatorDeclarer;
import org.apache.storm.trident.fluent.GlobalAggregationScheme;
import org.apache.storm.trident.fluent.IAggregatableStream;
import org.apache.storm.trident.operation.Aggregator;
import org.apache.storm.trident.operation.CombinerAggregator;
import org.apache.storm.trident.operation.Function;
import org.apache.storm.trident.operation.ReducerAggregator;
import org.apache.storm.trident.operation.impl.GroupedAggregator;
import org.apache.storm.trident.operation.impl.SingleEmitAggregator;
import org.apache.storm.trident.state.QueryFunction;
import org.apache.storm.trident.state.StateFactory;
import org.apache.storm.trident.state.StateSpec;
import org.apache.storm.trident.state.StateUpdater;
import org.apache.storm.trident.state.map.MapCombinerAggStateUpdater;
import org.apache.storm.trident.state.map.MapReducerAggStateUpdater;
import org.apache.storm.trident.util.TridentUtils;
import org.apache.storm.tuple.Fields;

public class GroupedStream
implements IAggregatableStream,
GlobalAggregationScheme<GroupedStream> {
    Fields _groupFields;
    Stream _stream;

    public GroupedStream(Stream stream, Fields groupFields) {
        this._groupFields = groupFields;
        this._stream = stream;
    }

    public GroupedStream name(String name) {
        return new GroupedStream(this._stream.name(name), this._groupFields);
    }

    public ChainedAggregatorDeclarer chainedAgg() {
        return new ChainedAggregatorDeclarer(this, this);
    }

    public Stream aggregate(Aggregator agg, Fields functionFields) {
        return this.aggregate(null, agg, functionFields);
    }

    public Stream aggregate(Fields inputFields, Aggregator agg, Fields functionFields) {
        return new ChainedAggregatorDeclarer(this, this).aggregate(inputFields, agg, functionFields).chainEnd();
    }

    public Stream aggregate(CombinerAggregator agg, Fields functionFields) {
        return this.aggregate(null, agg, functionFields);
    }

    public Stream aggregate(Fields inputFields, CombinerAggregator agg, Fields functionFields) {
        return new ChainedAggregatorDeclarer(this, this).aggregate(inputFields, agg, functionFields).chainEnd();
    }

    public Stream aggregate(ReducerAggregator agg, Fields functionFields) {
        return this.aggregate(null, agg, functionFields);
    }

    public Stream aggregate(Fields inputFields, ReducerAggregator agg, Fields functionFields) {
        return new ChainedAggregatorDeclarer(this, this).aggregate(inputFields, agg, functionFields).chainEnd();
    }

    public TridentState persistentAggregate(StateFactory stateFactory, CombinerAggregator agg, Fields functionFields) {
        return this.persistentAggregate(new StateSpec(stateFactory), agg, functionFields);
    }

    public TridentState persistentAggregate(StateSpec spec, CombinerAggregator agg, Fields functionFields) {
        return this.persistentAggregate(spec, null, agg, functionFields);
    }

    public TridentState persistentAggregate(StateFactory stateFactory, Fields inputFields, CombinerAggregator agg, Fields functionFields) {
        return this.persistentAggregate(new StateSpec(stateFactory), inputFields, agg, functionFields);
    }

    public TridentState persistentAggregate(StateSpec spec, Fields inputFields, CombinerAggregator agg, Fields functionFields) {
        return this.aggregate(inputFields, agg, functionFields).partitionPersist(spec, TridentUtils.fieldsUnion(this._groupFields, functionFields), (StateUpdater)new MapCombinerAggStateUpdater(agg, this._groupFields, functionFields), TridentUtils.fieldsConcat(this._groupFields, functionFields));
    }

    public TridentState persistentAggregate(StateFactory stateFactory, Fields inputFields, ReducerAggregator agg, Fields functionFields) {
        return this.persistentAggregate(new StateSpec(stateFactory), inputFields, agg, functionFields);
    }

    public TridentState persistentAggregate(StateSpec spec, Fields inputFields, ReducerAggregator agg, Fields functionFields) {
        return this._stream.partitionBy(this._groupFields).partitionPersist(spec, TridentUtils.fieldsUnion(this._groupFields, inputFields), (StateUpdater)new MapReducerAggStateUpdater(agg, this._groupFields, inputFields), TridentUtils.fieldsConcat(this._groupFields, functionFields));
    }

    public Stream stateQuery(TridentState state, Fields inputFields, QueryFunction function, Fields functionFields) {
        return this._stream.partitionBy(this._groupFields).stateQuery(state, inputFields, function, functionFields);
    }

    public TridentState persistentAggregate(StateFactory stateFactory, ReducerAggregator agg, Fields functionFields) {
        return this.persistentAggregate(new StateSpec(stateFactory), agg, functionFields);
    }

    public TridentState persistentAggregate(StateSpec spec, ReducerAggregator agg, Fields functionFields) {
        return this.persistentAggregate(spec, null, agg, functionFields);
    }

    public Stream stateQuery(TridentState state, QueryFunction function, Fields functionFields) {
        return this.stateQuery(state, null, function, functionFields);
    }

    @Override
    public IAggregatableStream each(Fields inputFields, Function function, Fields functionFields) {
        Stream s = this._stream.each(inputFields, function, functionFields);
        return new GroupedStream(s, this._groupFields);
    }

    @Override
    public IAggregatableStream partitionAggregate(Fields inputFields, Aggregator agg, Fields functionFields) {
        GroupedAggregator groupedAgg = new GroupedAggregator(agg, this._groupFields, inputFields, functionFields.size());
        Fields allInFields = TridentUtils.fieldsUnion(this._groupFields, inputFields);
        Fields allOutFields = TridentUtils.fieldsConcat(this._groupFields, functionFields);
        Stream s = this._stream.partitionAggregate(allInFields, groupedAgg, allOutFields);
        return new GroupedStream(s, this._groupFields);
    }

    @Override
    public IAggregatableStream aggPartition(GroupedStream s) {
        return new GroupedStream(s._stream.partitionBy(this._groupFields), this._groupFields);
    }

    @Override
    public Stream toStream() {
        return this._stream;
    }

    @Override
    public Fields getOutputFields() {
        return this._stream.getOutputFields();
    }

    public Fields getGroupFields() {
        return this._groupFields;
    }

    @Override
    public SingleEmitAggregator.BatchToPartition singleEmitPartitioner() {
        return null;
    }
}

