/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.operation;

import org.apache.storm.metric.api.CombinedMetric;
import org.apache.storm.metric.api.ICombiner;
import org.apache.storm.metric.api.IMetric;
import org.apache.storm.metric.api.IReducer;
import org.apache.storm.metric.api.ReducedMetric;
import org.apache.storm.task.IMetricsContext;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.trident.tuple.TridentTupleView;
import org.apache.storm.tuple.Fields;

public class TridentOperationContext
implements IMetricsContext {
    TridentTuple.Factory _factory;
    TopologyContext _topoContext;

    public TridentOperationContext(TopologyContext topoContext, TridentTuple.Factory factory) {
        this._factory = factory;
        this._topoContext = topoContext;
    }

    public TridentOperationContext(TridentOperationContext parent, TridentTuple.Factory factory) {
        this(parent._topoContext, factory);
    }

    public TridentTupleView.ProjectionFactory makeProjectionFactory(Fields fields) {
        return new TridentTupleView.ProjectionFactory(this._factory, fields);
    }

    public int numPartitions() {
        return this._topoContext.getComponentTasks(this._topoContext.getThisComponentId()).size();
    }

    public int getPartitionIndex() {
        return this._topoContext.getThisTaskIndex();
    }

    @Override
    public <T extends IMetric> T registerMetric(String name, T metric, int timeBucketSizeInSecs) {
        return this._topoContext.registerMetric(name, metric, timeBucketSizeInSecs);
    }

    @Override
    public ReducedMetric registerMetric(String name, IReducer reducer, int timeBucketSizeInSecs) {
        return this._topoContext.registerMetric(name, new ReducedMetric(reducer), timeBucketSizeInSecs);
    }

    @Override
    public CombinedMetric registerMetric(String name, ICombiner combiner, int timeBucketSizeInSecs) {
        return this._topoContext.registerMetric(name, new CombinedMetric(combiner), timeBucketSizeInSecs);
    }
}

