/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.planner.processor;

import java.util.List;
import java.util.Map;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.trident.operation.Aggregator;
import org.apache.storm.trident.operation.TridentOperationContext;
import org.apache.storm.trident.planner.ProcessorContext;
import org.apache.storm.trident.planner.TridentProcessor;
import org.apache.storm.trident.planner.processor.FreshCollector;
import org.apache.storm.trident.planner.processor.TridentContext;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.trident.tuple.TridentTupleView;
import org.apache.storm.tuple.Fields;

public class AggregateProcessor
implements TridentProcessor {
    Aggregator _agg;
    TridentContext _context;
    FreshCollector _collector;
    Fields _inputFields;
    TridentTupleView.ProjectionFactory _projection;

    public AggregateProcessor(Fields inputFields, Aggregator agg) {
        this._agg = agg;
        this._inputFields = inputFields;
    }

    @Override
    public void prepare(Map<String, Object> conf, TopologyContext context, TridentContext tridentContext) {
        List<TridentTuple.Factory> parents = tridentContext.getParentTupleFactories();
        if (parents.size() != 1) {
            throw new RuntimeException("Aggregate operation can only have one parent");
        }
        this._context = tridentContext;
        this._collector = new FreshCollector(tridentContext);
        this._projection = new TridentTupleView.ProjectionFactory(parents.get(0), this._inputFields);
        this._agg.prepare(conf, new TridentOperationContext(context, (TridentTuple.Factory)this._projection));
    }

    @Override
    public void cleanup() {
        this._agg.cleanup();
    }

    @Override
    public void startBatch(ProcessorContext processorContext) {
        this._collector.setContext(processorContext);
        processorContext.state[this._context.getStateIndex()] = this._agg.init(processorContext.batchId, this._collector);
    }

    @Override
    public void execute(ProcessorContext processorContext, String streamId, TridentTuple tuple) {
        this._collector.setContext(processorContext);
        this._agg.aggregate(processorContext.state[this._context.getStateIndex()], this._projection.create(tuple), this._collector);
    }

    @Override
    public void finishBatch(ProcessorContext processorContext) {
        this._collector.setContext(processorContext);
        this._agg.complete(processorContext.state[this._context.getStateIndex()], this._collector);
    }

    @Override
    public TridentTuple.Factory getOutputFactory() {
        return this._collector.getOutputFactory();
    }
}

