/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.planner.processor;

import java.util.Map;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.trident.planner.ProcessorContext;
import org.apache.storm.trident.planner.TridentProcessor;
import org.apache.storm.trident.planner.TupleReceiver;
import org.apache.storm.trident.planner.processor.TridentContext;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.trident.tuple.TridentTupleView;
import org.apache.storm.tuple.Fields;

public class ProjectedProcessor
implements TridentProcessor {
    Fields _projectFields;
    TridentTupleView.ProjectionFactory _factory;
    TridentContext _context;

    public ProjectedProcessor(Fields projectFields) {
        this._projectFields = projectFields;
    }

    @Override
    public void prepare(Map<String, Object> conf, TopologyContext context, TridentContext tridentContext) {
        if (tridentContext.getParentTupleFactories().size() != 1) {
            throw new RuntimeException("Projection processor can only have one parent");
        }
        this._context = tridentContext;
        this._factory = new TridentTupleView.ProjectionFactory(tridentContext.getParentTupleFactories().get(0), this._projectFields);
    }

    @Override
    public void cleanup() {
    }

    @Override
    public void startBatch(ProcessorContext processorContext) {
    }

    @Override
    public void execute(ProcessorContext processorContext, String streamId, TridentTuple tuple) {
        TridentTuple toEmit = this._factory.create(tuple);
        for (TupleReceiver r : this._context.getReceivers()) {
            r.execute(processorContext, this._context.getOutStreamId(), toEmit);
        }
    }

    @Override
    public void finishBatch(ProcessorContext processorContext) {
    }

    @Override
    public TridentTuple.Factory getOutputFactory() {
        return this._factory;
    }
}

