/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.state.map;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.trident.operation.ReducerAggregator;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.operation.TridentOperationContext;
import org.apache.storm.trident.state.ReducerValueUpdater;
import org.apache.storm.trident.state.StateUpdater;
import org.apache.storm.trident.state.ValueUpdater;
import org.apache.storm.trident.state.map.MapState;
import org.apache.storm.trident.tuple.ComboList;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.trident.tuple.TridentTupleView;
import org.apache.storm.tuple.Fields;
import org.apache.storm.tuple.Values;

public class MapReducerAggStateUpdater
implements StateUpdater<MapState> {
    private static final long serialVersionUID = 8667174018978959987L;
    ReducerAggregator _agg;
    Fields _groupFields;
    Fields _inputFields;
    transient TridentTupleView.ProjectionFactory _groupFactory;
    transient TridentTupleView.ProjectionFactory _inputFactory;
    ComboList.Factory _factory;

    public MapReducerAggStateUpdater(ReducerAggregator agg, Fields groupFields, Fields inputFields) {
        this._agg = agg;
        this._groupFields = groupFields;
        this._inputFields = inputFields;
        this._factory = new ComboList.Factory(groupFields.size(), 1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateState(MapState map, List<TridentTuple> tuples, TridentCollector collector) {
        void var8_14;
        HashMap grouped = new HashMap();
        for (TridentTuple t : tuples) {
            void var8_8;
            TridentTuple group = this._groupFactory.create(t);
            List list = (List)grouped.get(group);
            if (list == null) {
                ArrayList arrayList = new ArrayList();
                grouped.put(group, arrayList);
            }
            var8_8.add(this._inputFactory.create(t));
        }
        ArrayList<List<Object>> uniqueGroups = new ArrayList<List<Object>>(grouped.keySet());
        ArrayList<ValueUpdater> updaters = new ArrayList<ValueUpdater>(uniqueGroups.size());
        for (List list : uniqueGroups) {
            updaters.add(new ReducerValueUpdater(this._agg, (List)grouped.get(list)));
        }
        List results = map.multiUpdate(uniqueGroups, updaters);
        boolean bl = false;
        while (var8_14 < uniqueGroups.size()) {
            List group = (List)uniqueGroups.get((int)var8_14);
            Object result2 = results.get((int)var8_14);
            collector.emit(this._factory.create(new List[]{group, new Values(result2)}));
            ++var8_14;
        }
    }

    @Override
    public void prepare(Map<String, Object> conf, TridentOperationContext context) {
        this._groupFactory = context.makeProjectionFactory(this._groupFields);
        this._inputFactory = context.makeProjectionFactory(this._inputFields);
    }

    @Override
    public void cleanup() {
    }
}

