/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.state.map;

import java.util.ArrayList;
import java.util.List;
import org.apache.storm.trident.state.ValueUpdater;
import org.apache.storm.trident.state.map.IBackingMap;
import org.apache.storm.trident.state.map.MapState;

public class NonTransactionalMap<T>
implements MapState<T> {
    IBackingMap<T> _backing;

    public static <T> MapState<T> build(IBackingMap<T> backing) {
        return new NonTransactionalMap<T>(backing);
    }

    protected NonTransactionalMap(IBackingMap<T> backing) {
        this._backing = backing;
    }

    @Override
    public List<T> multiGet(List<List<Object>> keys) {
        return this._backing.multiGet(keys);
    }

    @Override
    public List<T> multiUpdate(List<List<Object>> keys, List<ValueUpdater> updaters) {
        List<T> curr = this._backing.multiGet(keys);
        ArrayList<T> ret = new ArrayList<T>(curr.size());
        for (int i = 0; i < curr.size(); ++i) {
            T currVal = curr.get(i);
            ValueUpdater updater = updaters.get(i);
            ret.add(updater.update(currVal));
        }
        this._backing.multiPut(keys, ret);
        return ret;
    }

    @Override
    public void multiPut(List<List<Object>> keys, List<T> vals) {
        this._backing.multiPut(keys, vals);
    }

    @Override
    public void beginCommit(Long txid) {
    }

    @Override
    public void commit(Long txid) {
    }
}

