/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.trident.topology.state;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.PathAndBytesable;
import org.apache.curator.framework.api.ProtectACLCreateModePathAndBytesable;
import org.apache.storm.utils.CuratorUtils;
import org.apache.storm.utils.Utils;
import org.apache.storm.utils.ZookeeperAuthInfo;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.ACL;
import org.json.simple.JSONValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionalState {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionalState.class);
    CuratorFramework _curator;
    List<ACL> _zkAcls = null;

    public static TransactionalState newUserState(Map<String, Object> conf, String id) {
        return new TransactionalState(conf, id, "user");
    }

    public static TransactionalState newCoordinatorState(Map<String, Object> conf, String id) {
        return new TransactionalState(conf, id, "coordinator");
    }

    protected TransactionalState(Map<String, Object> conf, String id, String subroot) {
        try {
            conf = new HashMap<String, Object>(conf);
            String transactionalRoot = (String)conf.get("transactional.zookeeper.root");
            String rootDir = transactionalRoot + "/" + id + "/" + subroot;
            List servers = (List)this.getWithBackup(conf, "transactional.zookeeper.servers", "storm.zookeeper.servers");
            Object port = this.getWithBackup(conf, "transactional.zookeeper.port", "storm.zookeeper.port");
            ZookeeperAuthInfo auth = new ZookeeperAuthInfo(conf);
            CuratorFramework initter = CuratorUtils.newCuratorStarted(conf, servers, port, auth);
            this._zkAcls = Utils.getWorkerACL(conf);
            try {
                TransactionalState.createNode(initter, transactionalRoot, null, null, null);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                // empty catch block
            }
            try {
                TransactionalState.createNode(initter, rootDir, null, this._zkAcls, null);
            }
            catch (KeeperException.NodeExistsException nodeExistsException) {
                // empty catch block
            }
            initter.close();
            this._curator = CuratorUtils.newCuratorStarted(conf, servers, port, rootDir, auth);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected static String forPath(PathAndBytesable<String> builder, String path, byte[] data) throws Exception {
        return data == null ? (String)builder.forPath(path) : (String)builder.forPath(path, data);
    }

    protected static void createNode(CuratorFramework curator, String path, byte[] data, List<ACL> acls, CreateMode mode) throws Exception {
        ProtectACLCreateModePathAndBytesable builder = curator.create().creatingParentsIfNeeded();
        LOG.debug("Creating node  [path = {}],  [data = {}],  [acls = {}],  [mode = {}]", new Object[]{path, TransactionalState.asString(data), acls, mode});
        if (acls == null) {
            if (mode == null) {
                TransactionalState.forPath((PathAndBytesable<String>)builder, path, data);
            } else {
                TransactionalState.forPath((PathAndBytesable<String>)((PathAndBytesable)builder.withMode(mode)), path, data);
            }
            return;
        }
        TransactionalState.forPath((PathAndBytesable<String>)((PathAndBytesable)builder.withACL(acls)), path, data);
    }

    private static String asString(byte[] data) {
        return data == null ? "null" : new String(data);
    }

    public void setData(String path, Object obj) {
        byte[] ser;
        path = "/" + path;
        try {
            ser = JSONValue.toJSONString((Object)obj).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        try {
            if (this._curator.checkExists().forPath(path) != null) {
                this._curator.setData().forPath(path, ser);
            } else {
                TransactionalState.createNode(this._curator, path, ser, this._zkAcls, CreateMode.PERSISTENT);
            }
        }
        catch (KeeperException.NodeExistsException nne) {
            LOG.warn("Node {} already created.", (Object)path);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void delete(String path) {
        path = "/" + path;
        try {
            this._curator.delete().forPath(path);
        }
        catch (KeeperException.NoNodeException nne) {
            LOG.warn("Path {} already deleted.");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LOG.debug("Deleted [path = {}]", (Object)path);
    }

    public List<String> list(String path) {
        path = "/" + path;
        try {
            List children = this._curator.checkExists().forPath(path) == null ? new ArrayList() : (List)this._curator.getChildren().forPath(path);
            LOG.debug("List [path = {}], [children = {}]", (Object)path, children);
            return children;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void mkdir(String path) {
        this.setData(path, 7);
    }

    public Object getData(String path) {
        path = "/" + path;
        try {
            Object data = this._curator.checkExists().forPath(path) != null ? JSONValue.parse((String)new String((byte[])this._curator.getData().forPath(path), "UTF-8")) : null;
            LOG.debug("Get. [path = {}] => [data = {}]", (Object)path, data);
            return data;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        this._curator.close();
    }

    private Object getWithBackup(Map amap, Object primary, Object backup) {
        Object ret = amap.get(primary);
        if (ret == null) {
            return amap.get(backup);
        }
        return ret;
    }
}

