/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import com.google.common.collect.Lists;
import java.security.Principal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.generated.Nimbus;
import org.apache.storm.generated.NimbusSummary;
import org.apache.storm.security.auth.ReqContext;
import org.apache.storm.security.auth.ThriftClient;
import org.apache.storm.security.auth.ThriftConnectionType;
import org.apache.storm.utils.ConfigUtils;
import org.apache.storm.utils.NimbusLeaderNotFoundException;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NimbusClient
extends ThriftClient {
    private static volatile Nimbus.Iface _localOverrideClient = null;
    private Nimbus.Iface _client;
    public final boolean _isLocal;
    private static final Logger LOG = LoggerFactory.getLogger(NimbusClient.class);

    public static boolean isLocalOverride() {
        return _localOverrideClient != null;
    }

    public static void withConfiguredClient(WithNimbus cb) throws Exception {
        NimbusClient.withConfiguredClient(cb, ConfigUtils.readStormConfig());
    }

    public static void withConfiguredClient(WithNimbus cb, Map<String, Object> conf) throws Exception {
        ReqContext context = ReqContext.context();
        Principal principal = context.principal();
        String user = principal == null ? null : principal.getName();
        try (NimbusClient client = NimbusClient.getConfiguredClientAs(conf, user);){
            cb.run(client.getClient());
        }
    }

    public static NimbusClient getConfiguredClient(Map<String, Object> conf) {
        return NimbusClient.getConfiguredClientAs(conf, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NimbusClient getConfiguredClientAs(Map<String, Object> conf, String asUser) {
        List seeds;
        Nimbus.Iface override = _localOverrideClient;
        if (override != null) {
            return new NimbusClient(override);
        }
        if (conf.containsKey("storm.doAsUser")) {
            if (asUser != null && !asUser.isEmpty()) {
                LOG.warn("You have specified a doAsUser as param {} and a doAsParam as config, config will take precedence.", (Object)asUser, conf.get("storm.doAsUser"));
            }
            asUser = (String)conf.get("storm.doAsUser");
        }
        if (conf.containsKey("nimbus.host")) {
            LOG.warn("Using deprecated config {} for backward compatibility. Please update your storm.yaml so it only has config {}", (Object)"nimbus.host", (Object)"nimbus.seeds");
            seeds = Lists.newArrayList((Object[])new String[]{conf.get("nimbus.host").toString()});
        } else {
            seeds = (List)conf.get("nimbus.seeds");
        }
        for (String host : seeds) {
            int port = Integer.parseInt(conf.get("nimbus.thrift.port").toString());
            ThriftClient client = null;
            try {
                client = new NimbusClient(conf, host, port, null, asUser);
                NimbusSummary nimbusSummary = ((NimbusClient)client).getClient().getLeader();
                if (nimbusSummary != null) {
                    String leaderNimbus = nimbusSummary.get_host() + ":" + nimbusSummary.get_port();
                    LOG.info("Found leader nimbus : {}", (Object)leaderNimbus);
                    if (nimbusSummary.get_host().equals(host) && nimbusSummary.get_port() == port) {
                        ThriftClient ret = client;
                        client = null;
                        ThriftClient thriftClient = ret;
                        return thriftClient;
                    }
                    NimbusClient ret = new NimbusClient(conf, nimbusSummary.get_host(), nimbusSummary.get_port(), null, asUser);
                    return ret;
                }
            }
            catch (Exception e) {
                LOG.warn("Ignoring exception while trying to get leader nimbus info from " + host + ". will retry with a different seed host.", (Throwable)e);
                continue;
            }
            finally {
                if (client == null) continue;
                client.close();
                continue;
            }
            throw new NimbusLeaderNotFoundException("Could not find a nimbus leader, please try again after some time.");
        }
        throw new NimbusLeaderNotFoundException("Could not find leader nimbus from seed hosts " + seeds + ". Did you specify a valid list of nimbus hosts for config " + "nimbus.seeds" + "?");
    }

    public NimbusClient(Map<String, Object> conf, String host, int port) throws TTransportException {
        this(conf, host, port, null, null);
    }

    public NimbusClient(Map<String, Object> conf, String host, int port, Integer timeout) throws TTransportException {
        super(conf, ThriftConnectionType.NIMBUS, host, port, timeout, null);
        this._client = new Nimbus.Client(this._protocol);
        this._isLocal = false;
    }

    public NimbusClient(Map<String, Object> conf, String host, Integer port, Integer timeout, String asUser) throws TTransportException {
        super(conf, ThriftConnectionType.NIMBUS, host, port, timeout, asUser);
        this._client = new Nimbus.Client(this._protocol);
        this._isLocal = false;
    }

    public NimbusClient(Map<String, Object> conf, String host) throws TTransportException {
        super(conf, ThriftConnectionType.NIMBUS, host, null, null, null);
        this._client = new Nimbus.Client(this._protocol);
        this._isLocal = false;
    }

    private NimbusClient(Nimbus.Iface client) {
        super(new HashMap<String, Object>(), ThriftConnectionType.LOCAL_FAKE, "localhost", null, null, null);
        this._client = client;
        this._isLocal = true;
    }

    public Nimbus.Iface getClient() {
        return this._client;
    }

    public static interface WithNimbus {
        public void run(Nimbus.Iface var1) throws Exception;
    }

    public static final class LocalOverride
    implements AutoCloseable {
        public LocalOverride(Nimbus.Iface client) {
            _localOverrideClient = client;
        }

        @Override
        public void close() throws Exception {
            _localOverrideClient = null;
        }
    }
}

