/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ObjectReader {
    public static List<String> getStrings(final Object o) {
        if (o == null) {
            return new ArrayList<String>();
        }
        if (o instanceof String) {
            return new ArrayList<String>(){
                {
                    this.add((String)o);
                }
            };
        }
        if (o instanceof Collection) {
            ArrayList<String> answer = new ArrayList<String>();
            for (Object v : (Collection)o) {
                answer.add(v.toString());
            }
            return answer;
        }
        throw new IllegalArgumentException("Don't know how to convert to string list");
    }

    public static String getString(Object o) {
        if (null == o) {
            throw new IllegalArgumentException("Don't know how to convert null to String");
        }
        return o.toString();
    }

    public static Integer getInt(Object o) {
        Integer result2 = ObjectReader.getInt(o, null);
        if (null == result2) {
            throw new IllegalArgumentException("Don't know how to convert null to int");
        }
        return result2;
    }

    public static Integer getInt(Object o, Integer defaultValue) {
        if (null == o) {
            return defaultValue;
        }
        if (o instanceof Integer || o instanceof Short || o instanceof Byte) {
            return ((Number)o).intValue();
        }
        if (o instanceof Long) {
            long l = (Long)o;
            if (l <= Integer.MAX_VALUE && l >= Integer.MIN_VALUE) {
                return (int)l;
            }
        } else if (o instanceof String) {
            return Integer.parseInt((String)o);
        }
        throw new IllegalArgumentException("Don't know how to convert " + o + " to int");
    }

    public static Double getDouble(Object o) {
        Double result2 = ObjectReader.getDouble(o, null);
        if (null == result2) {
            throw new IllegalArgumentException("Don't know how to convert null to double");
        }
        return result2;
    }

    public static Double getDouble(Object o, Double defaultValue) {
        if (null == o) {
            return defaultValue;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        throw new IllegalArgumentException("Don't know how to convert " + o + " + to double");
    }

    public static boolean getBoolean(Object o, boolean defaultValue) {
        if (null == o) {
            return defaultValue;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        throw new IllegalArgumentException("Don't know how to convert " + o + " + to boolean");
    }

    public static String getString(Object o, String defaultValue) {
        if (null == o) {
            return defaultValue;
        }
        if (o instanceof String) {
            return (String)o;
        }
        throw new IllegalArgumentException("Don't know how to convert " + o + " + to String");
    }
}

