/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.storm.multilang.BoltMsg;
import org.apache.storm.multilang.ISerializer;
import org.apache.storm.multilang.NoOutputException;
import org.apache.storm.multilang.ShellMsg;
import org.apache.storm.multilang.SpoutMsg;
import org.apache.storm.task.TopologyContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShellProcess
implements Serializable {
    public static final Logger LOG = LoggerFactory.getLogger(ShellProcess.class);
    public static Logger ShellLogger;
    private Process _subprocess;
    private InputStream processErrorStream;
    private String[] command;
    private Map<String, String> env = new HashMap<String, String>();
    public ISerializer serializer;
    public Number pid;
    public String componentName;

    public ShellProcess(String[] command) {
        this.command = command;
    }

    public void setEnv(Map<String, String> env) {
        this.env = env;
    }

    private void modifyEnvironment(Map<String, String> buildEnv) {
        for (Map.Entry<String, String> entry : this.env.entrySet()) {
            if ("PATH".equals(entry.getKey())) {
                buildEnv.put("PATH", buildEnv.get("PATH") + File.pathSeparatorChar + this.env.get("PATH"));
                continue;
            }
            buildEnv.put(entry.getKey(), entry.getValue());
        }
    }

    public Number launch(Map<String, Object> conf, TopologyContext context) {
        return this.launch(conf, context, true);
    }

    public Number launch(Map<String, Object> conf, TopologyContext context, boolean changeDirectory) {
        ProcessBuilder builder = new ProcessBuilder(this.command);
        if (!this.env.isEmpty()) {
            Map<String, String> buildEnv = builder.environment();
            this.modifyEnvironment(buildEnv);
        }
        if (changeDirectory) {
            builder.directory(new File(context.getCodeDir()));
        }
        ShellLogger = LoggerFactory.getLogger((String)context.getThisComponentId());
        this.componentName = context.getThisComponentId();
        this.serializer = this.getSerializer(conf);
        try {
            this._subprocess = builder.start();
            this.processErrorStream = this._subprocess.getErrorStream();
            this.serializer.initialize(this._subprocess.getOutputStream(), this._subprocess.getInputStream());
            this.pid = this.serializer.connect(conf, context);
        }
        catch (IOException e) {
            throw new RuntimeException("Error when launching multilang subprocess\n" + this.getErrorsString(), e);
        }
        catch (NoOutputException e) {
            throw new RuntimeException(e + this.getErrorsString() + "\n");
        }
        return this.pid;
    }

    private ISerializer getSerializer(Map<String, Object> conf) {
        ISerializer serializer;
        String serializer_className = (String)conf.get("topology.multilang.serializer");
        LOG.info("Storm multilang serializer: " + serializer_className);
        try {
            Class<?> klass = Class.forName(serializer_className);
            Object obj = klass.newInstance();
            serializer = (ISerializer)obj;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to construct multilang serializer from serializer " + serializer_className, e);
        }
        return serializer;
    }

    public void destroy() {
        this._subprocess.destroy();
    }

    public ShellMsg readShellMsg() throws IOException {
        try {
            return this.serializer.readShellMsg();
        }
        catch (NoOutputException e) {
            throw new RuntimeException(e + this.getErrorsString() + "\n");
        }
    }

    public void writeBoltMsg(BoltMsg msg) throws IOException {
        this.serializer.writeBoltMsg(msg);
        this.logErrorStream();
    }

    public void writeSpoutMsg(SpoutMsg msg) throws IOException {
        this.serializer.writeSpoutMsg(msg);
        this.logErrorStream();
    }

    public void writeTaskIds(List<Integer> taskIds) throws IOException {
        this.serializer.writeTaskIds(taskIds);
        this.logErrorStream();
    }

    public void logErrorStream() {
        try {
            while (this.processErrorStream.available() > 0) {
                int bufferSize = this.processErrorStream.available();
                byte[] errorReadingBuffer = new byte[bufferSize];
                this.processErrorStream.read(errorReadingBuffer, 0, bufferSize);
                ShellLogger.info(new String(errorReadingBuffer));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getErrorsString() {
        if (this.processErrorStream != null) {
            try {
                StringBuilder sb = new StringBuilder();
                while (this.processErrorStream.available() > 0) {
                    int bufferSize = this.processErrorStream.available();
                    byte[] errorReadingBuffer = new byte[bufferSize];
                    this.processErrorStream.read(errorReadingBuffer, 0, bufferSize);
                    sb.append(new String(errorReadingBuffer));
                }
                return sb.toString();
            }
            catch (IOException e) {
                return "(Unable to capture error stream)";
            }
        }
        return "";
    }

    public Number getPid() {
        return this.pid;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public int getExitCode() {
        try {
            return this._subprocess != null ? this._subprocess.exitValue() : -1;
        }
        catch (IllegalThreadStateException e) {
            return -1;
        }
    }

    public String getProcessInfoString() {
        return String.format("pid:%s, name:%s", this.pid, this.componentName);
    }

    public String getProcessTerminationInfoString() {
        return String.format(" exitCode:%s, errorString:%s ", this.getExitCode(), this.getErrorsString());
    }
}

