/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.util.Random;
import org.apache.curator.retry.BoundedExponentialBackoffRetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StormBoundedExponentialBackoffRetry
extends BoundedExponentialBackoffRetry {
    private static final Logger LOG = LoggerFactory.getLogger(StormBoundedExponentialBackoffRetry.class);
    private int stepSize;
    private int expRetriesThreshold = 1;
    private final Random random = new Random();
    private final int linearBaseSleepMs;

    public StormBoundedExponentialBackoffRetry(int baseSleepTimeMs, int maxSleepTimeMs, int maxRetries) {
        super(baseSleepTimeMs, maxSleepTimeMs, maxRetries);
        while (1 << this.expRetriesThreshold + 1 < (maxSleepTimeMs - baseSleepTimeMs) / 2) {
            ++this.expRetriesThreshold;
        }
        LOG.debug("The baseSleepTimeMs [{}] the maxSleepTimeMs [{}] the maxRetries [{}]", new Object[]{baseSleepTimeMs, maxSleepTimeMs, maxRetries});
        if (baseSleepTimeMs > maxSleepTimeMs) {
            LOG.warn("Misconfiguration: the baseSleepTimeMs [" + baseSleepTimeMs + "] can't be greater than the maxSleepTimeMs [" + maxSleepTimeMs + "].");
        }
        this.stepSize = maxRetries > 0 && maxRetries > this.expRetriesThreshold ? Math.max(1, (maxSleepTimeMs - (1 << this.expRetriesThreshold)) / (maxRetries - this.expRetriesThreshold)) : 1;
        this.linearBaseSleepMs = super.getBaseSleepTimeMs() + (1 << this.expRetriesThreshold);
    }

    public long getSleepTimeMs(int retryCount, long elapsedTimeMs) {
        if (retryCount < this.expRetriesThreshold) {
            int exp = 1 << retryCount;
            int jitter = this.random.nextInt(exp);
            long sleepTimeMs = super.getBaseSleepTimeMs() + exp + jitter;
            LOG.warn("WILL SLEEP FOR {}ms (NOT MAX)", (Object)sleepTimeMs);
            return sleepTimeMs;
        }
        int stepJitter = this.random.nextInt(this.stepSize);
        long sleepTimeMs = Math.min(super.getMaxSleepTimeMs(), this.linearBaseSleepMs + this.stepSize * (retryCount - this.expRetriesThreshold) + stepJitter);
        LOG.warn("WILL SLEEP FOR {}ms (MAX)", (Object)sleepTimeMs);
        return sleepTimeMs;
    }
}

