/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.storm.generated.NodeInfo;
import org.apache.storm.messaging.IConnection;
import org.apache.storm.messaging.TaskMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferDrainer {
    private Map<Integer, ArrayList<ArrayList<TaskMessage>>> bundles = new HashMap<Integer, ArrayList<ArrayList<TaskMessage>>>();
    private static final Logger LOG = LoggerFactory.getLogger(TransferDrainer.class);

    public void add(HashMap<Integer, ArrayList<TaskMessage>> taskTupleSetMap) {
        for (Map.Entry<Integer, ArrayList<TaskMessage>> entry : taskTupleSetMap.entrySet()) {
            this.addListRefToMap(this.bundles, entry.getKey(), entry.getValue());
        }
    }

    public void send(Map<Integer, NodeInfo> taskToNode, Map<NodeInfo, IConnection> connections) {
        HashMap<NodeInfo, ArrayList<ArrayList<TaskMessage>>> bundleMapByDestination = this.groupBundleByDestination(taskToNode);
        for (Map.Entry<NodeInfo, ArrayList<ArrayList<TaskMessage>>> entry : bundleMapByDestination.entrySet()) {
            NodeInfo hostPort = entry.getKey();
            IConnection connection = connections.get(hostPort);
            if (null != connection) {
                ArrayList<ArrayList<TaskMessage>> bundle = entry.getValue();
                Iterator<TaskMessage> iter = this.getBundleIterator(bundle);
                if (null == iter || !iter.hasNext()) continue;
                connection.send(iter);
                continue;
            }
            LOG.warn("Connection is not available for hostPort {}", (Object)hostPort);
        }
    }

    private HashMap<NodeInfo, ArrayList<ArrayList<TaskMessage>>> groupBundleByDestination(Map<Integer, NodeInfo> taskToNode) {
        HashMap bundleMap = Maps.newHashMap();
        for (Integer task : this.bundles.keySet()) {
            NodeInfo hostPort = taskToNode.get(task);
            if (hostPort != null) {
                for (ArrayList<TaskMessage> chunk : this.bundles.get(task)) {
                    this.addListRefToMap(bundleMap, hostPort, chunk);
                }
                continue;
            }
            LOG.warn("No remote destination available for task {}", (Object)task);
        }
        return bundleMap;
    }

    private <T> void addListRefToMap(Map<T, ArrayList<ArrayList<TaskMessage>>> bundleMap, T key, ArrayList<TaskMessage> tuples) {
        ArrayList<ArrayList<TaskMessage>> bundle = bundleMap.get(key);
        if (null == bundle) {
            bundle = new ArrayList();
            bundleMap.put(key, bundle);
        }
        if (null != tuples && tuples.size() > 0) {
            bundle.add(tuples);
        }
    }

    private Iterator<TaskMessage> getBundleIterator(final ArrayList<ArrayList<TaskMessage>> bundle) {
        if (null == bundle) {
            return null;
        }
        return new Iterator<TaskMessage>(){
            private int offset = 0;
            private int size = 0;
            private int bundleOffset;
            private Iterator<TaskMessage> iter;
            {
                for (ArrayList list : bundle) {
                    this.size += list.size();
                }
                this.bundleOffset = 0;
                this.iter = ((ArrayList)bundle.get(this.bundleOffset)).iterator();
            }

            @Override
            public boolean hasNext() {
                return this.offset < this.size;
            }

            @Override
            public TaskMessage next() {
                TaskMessage msg;
                if (this.iter.hasNext()) {
                    msg = this.iter.next();
                } else {
                    ++this.bundleOffset;
                    this.iter = ((ArrayList)bundle.get(this.bundleOffset)).iterator();
                    msg = this.iter.next();
                }
                if (null != msg) {
                    ++this.offset;
                }
                return msg;
            }

            @Override
            public void remove() {
                throw new RuntimeException("not supported");
            }
        };
    }

    public void clear() {
        this.bundles.clear();
    }
}

