/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.input.ClassLoaderObjectInputStream;
import org.apache.storm.blobstore.ClientBlobStore;
import org.apache.storm.generated.ClusterSummary;
import org.apache.storm.generated.ComponentCommon;
import org.apache.storm.generated.ComponentObject;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.generated.InvalidTopologyException;
import org.apache.storm.generated.Nimbus;
import org.apache.storm.generated.StormTopology;
import org.apache.storm.generated.TopologyInfo;
import org.apache.storm.generated.TopologySummary;
import org.apache.storm.serialization.DefaultSerializationDelegate;
import org.apache.storm.serialization.SerializationDelegate;
import org.apache.storm.utils.IPredicate;
import org.apache.storm.utils.NimbusClient;
import org.apache.storm.utils.ReflectionUtils;
import org.apache.storm.utils.Time;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;

public class Utils {
    public static final Logger LOG = LoggerFactory.getLogger(Utils.class);
    public static final String DEFAULT_STREAM_ID = "default";
    public static final String FILE_PATH_SEPARATOR = System.getProperty("file.separator");
    private static ThreadLocal<TSerializer> threadSer = new ThreadLocal();
    private static ThreadLocal<TDeserializer> threadDes = new ThreadLocal();
    private static ClassLoader cl = null;
    private static Map<String, Object> localConf = Utils.readStormConfig();
    static SerializationDelegate serializationDelegate = Utils.getSerializationDelegate(localConf);
    private static Utils _instance = new Utils();
    private static String memoizedLocalHostnameString = null;

    public static Utils setInstance(Utils u) {
        Utils oldInstance = _instance;
        _instance = u;
        return oldInstance;
    }

    @VisibleForTesting
    public static void setClassLoaderForJavaDeSerialize(ClassLoader cl) {
        Utils.cl = cl;
    }

    @VisibleForTesting
    public static void resetClassLoaderForJavaDeSerialize() {
        cl = ClassLoader.getSystemClassLoader();
    }

    public static List<URL> findResources(String name) {
        try {
            Enumeration<URL> resources = Thread.currentThread().getContextClassLoader().getResources(name);
            ArrayList<URL> ret = new ArrayList<URL>();
            while (resources.hasMoreElements()) {
                ret.add(resources.nextElement());
            }
            return ret;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> findAndReadConfigFile(String name, boolean mustExist) {
        InputStream in = null;
        boolean confFileEmpty = false;
        try {
            Yaml yaml;
            in = Utils.getConfigFileInputStream(name);
            if (null != in) {
                yaml = new Yaml((BaseConstructor)new SafeConstructor());
                Map ret = (Map)yaml.load((Reader)new InputStreamReader(in));
                if (null != ret) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>(ret);
                    return hashMap;
                }
                confFileEmpty = true;
            }
            if (mustExist) {
                if (confFileEmpty) {
                    throw new RuntimeException("Config file " + name + " doesn't have any valid storm configs");
                }
                throw new RuntimeException("Could not find config file on classpath " + name);
            }
            yaml = new HashMap();
            return yaml;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private static InputStream getConfigFileInputStream(String configFilePath) throws IOException {
        if (null == configFilePath) {
            throw new IOException("Could not find config file, name not specified");
        }
        HashSet<URL> resources = new HashSet<URL>(Utils.findResources(configFilePath));
        if (resources.isEmpty()) {
            File configFile = new File(configFilePath);
            if (configFile.exists()) {
                return new FileInputStream(configFile);
            }
        } else {
            if (resources.size() > 1) {
                throw new IOException("Found multiple " + configFilePath + " resources. You're probably bundling the Storm jars with your topology jar. " + resources);
            }
            LOG.debug("Using " + configFilePath + " from resources");
            URL resource = resources.iterator().next();
            return resource.openStream();
        }
        return null;
    }

    public static Map<String, Object> readDefaultConfig() {
        return Utils.findAndReadConfigFile("defaults.yaml", true);
    }

    public static Map<String, Object> readCommandLineOpts() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        String commandOptions = System.getProperty("storm.options");
        if (commandOptions != null) {
            String[] configs;
            for (String config : configs = commandOptions.split(",(?![^\\[\\]{}]*(]|}))")) {
                String[] options = (config = URLDecoder.decode(config)).split("=", 2);
                if (options.length != 2) continue;
                Object val = options[1];
                try {
                    val = JSONValue.parseWithException((String)options[1]);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                ret.put(options[0], val);
            }
        }
        return ret;
    }

    public static Map<String, Object> readStormConfig() {
        Map<String, Object> ret = Utils.readDefaultConfig();
        String confFile = System.getProperty("storm.conf.file");
        Map<String, Object> storm = confFile == null || confFile.equals("") ? Utils.findAndReadConfigFile("storm.yaml", false) : Utils.findAndReadConfigFile(confFile, true);
        ret.putAll(storm);
        ret.putAll(Utils.readCommandLineOpts());
        return ret;
    }

    public static long bitXorVals(List<Long> coll) {
        long result2 = 0L;
        for (Long val : coll) {
            result2 ^= val.longValue();
        }
        return result2;
    }

    public static long bitXor(Long a, Long b) {
        return a ^ b;
    }

    public static void addShutdownHookWithForceKillIn1Sec(Runnable func) {
        Runnable sleepKill = new Runnable(){

            @Override
            public void run() {
                try {
                    Time.sleepSecs(1L);
                    LOG.warn("Forceing Halt...");
                    Runtime.getRuntime().halt(20);
                }
                catch (Exception e) {
                    LOG.warn("Exception in the ShutDownHook", (Throwable)e);
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(new Thread(func));
        Runtime.getRuntime().addShutdownHook(new Thread(sleepKill));
    }

    public static boolean isSystemId(String id) {
        return id.startsWith("__");
    }

    public static SmartThread asyncLoop(final Callable afn, boolean isDaemon, Thread.UncaughtExceptionHandler eh, int priority, final boolean isFactory, boolean startImmediately, String threadName) {
        SmartThread thread = new SmartThread(new Runnable(){

            @Override
            public void run() {
                try {
                    Object s;
                    Callable fn;
                    Callable callable = fn = isFactory ? (Callable)afn.call() : afn;
                    while ((s = fn.call()) instanceof Long) {
                        Time.sleepSecs((Long)s);
                    }
                }
                catch (Throwable t) {
                    if (Utils.exceptionCauseIsInstanceOf(InterruptedException.class, t)) {
                        LOG.info("Async loop interrupted!");
                        return;
                    }
                    LOG.error("Async loop died!", t);
                    throw new RuntimeException(t);
                }
            }
        });
        if (eh != null) {
            thread.setUncaughtExceptionHandler(eh);
        } else {
            thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    LOG.error("Async loop died!", e);
                    Utils.exitProcess(1, "Async loop died!");
                }
            });
        }
        thread.setDaemon(isDaemon);
        thread.setPriority(priority);
        if (threadName != null && !threadName.isEmpty()) {
            thread.setName(thread.getName() + "-" + threadName);
        }
        if (startImmediately) {
            thread.start();
        }
        return thread;
    }

    public static SmartThread asyncLoop(Callable afn, String threadName, Thread.UncaughtExceptionHandler eh) {
        return Utils.asyncLoop(afn, false, eh, 5, false, true, threadName);
    }

    public static SmartThread asyncLoop(Callable afn) {
        return Utils.asyncLoop(afn, false, null, 5, false, true, null);
    }

    public static boolean exceptionCauseIsInstanceOf(Class klass, Throwable throwable) {
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            if (!klass.isInstance(t)) continue;
            return true;
        }
        return false;
    }

    public static RuntimeException wrapInRuntime(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new RuntimeException(e);
    }

    public static long secureRandomLong() {
        return UUID.randomUUID().getLeastSignificantBits();
    }

    public static String hostname() throws UnknownHostException {
        return _instance.hostnameImpl();
    }

    public static String localHostname() throws UnknownHostException {
        return _instance.localHostnameImpl();
    }

    public static void exitProcess(int val, String msg) {
        String combinedErrorMessage = "Halting process: " + msg;
        LOG.error(combinedErrorMessage, (Throwable)new RuntimeException(combinedErrorMessage));
        Runtime.getRuntime().exit(val);
    }

    public static String uuid() {
        return UUID.randomUUID().toString();
    }

    public static byte[] javaSerialize(Object obj) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            oos.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T javaDeserialize(byte[] serialized, Class<T> clazz) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(serialized);
            ObjectInputStream ois = null;
            ois = null == cl ? new ObjectInputStream(bis) : new ClassLoaderObjectInputStream(cl, (InputStream)bis);
            Object ret = ois.readObject();
            ois.close();
            return (T)ret;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <S, T> T get(Map<S, T> m, S key, T def) {
        T ret = m.get(key);
        if (ret == null) {
            ret = def;
        }
        return ret;
    }

    public static double zeroIfNaNOrInf(double x) {
        return Double.isNaN(x) || Double.isInfinite(x) ? 0.0 : x;
    }

    public static <T> String join(Iterable<T> coll, String sep) {
        Iterator<T> it = coll.iterator();
        StringBuilder ret = new StringBuilder();
        while (it.hasNext()) {
            ret.append(it.next());
            if (!it.hasNext()) continue;
            ret.append(sep);
        }
        return ret.toString();
    }

    public static List<ACL> getWorkerACL(Map<String, Object> conf) {
        if (!Utils.isZkAuthenticationConfiguredTopology(conf)) {
            return null;
        }
        String stormZKUser = (String)conf.get("storm.zookeeper.superACL");
        if (stormZKUser == null) {
            throw new IllegalArgumentException("Authentication is enabled but storm.zookeeper.superACL is not set");
        }
        String[] split = stormZKUser.split(":", 2);
        if (split.length != 2) {
            throw new IllegalArgumentException("storm.zookeeper.superACL does not appear to be in the form scheme:acl, i.e. sasl:storm-user");
        }
        ArrayList<ACL> ret = new ArrayList<ACL>(ZooDefs.Ids.CREATOR_ALL_ACL);
        ret.add(new ACL(31, new Id(split[0], split[1])));
        return ret;
    }

    public static boolean isZkAuthenticationConfiguredTopology(Map<String, Object> conf) {
        return conf != null && conf.get("storm.zookeeper.topology.auth.scheme") != null && !((String)conf.get("storm.zookeeper.topology.auth.scheme")).isEmpty();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void handleUncaughtException(Throwable t) {
        if (t != null && t instanceof Error) {
            if (!(t instanceof OutOfMemoryError)) throw (Error)t;
            try {
                System.err.println("Halting due to Out Of Memory Error..." + Thread.currentThread().getName());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            Runtime.getRuntime().halt(-1);
            return;
        }
        if (!(t instanceof Exception)) return;
        System.err.println("Uncaught Exception detected. Leave error log and ignore... Exception: " + t);
        System.err.println("Stack trace:");
        StringWriter sw = new StringWriter();
        t.printStackTrace(new PrintWriter(sw));
        System.err.println(sw.toString());
    }

    public static byte[] thriftSerialize(TBase t) {
        try {
            TSerializer ser = threadSer.get();
            if (ser == null) {
                ser = new TSerializer();
                threadSer.set(ser);
            }
            return ser.serialize(t);
        }
        catch (TException e) {
            LOG.error("Failed to serialize to thrift: ", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static <T> T thriftDeserialize(Class<T> c, byte[] b) {
        try {
            return Utils.thriftDeserialize(c, b, 0, b.length);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T thriftDeserialize(Class<T> c, byte[] b, int offset, int length) {
        try {
            T ret = c.newInstance();
            TDeserializer des = Utils.getDes();
            des.deserialize((TBase)ret, b, offset, length);
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static TDeserializer getDes() {
        TDeserializer des = threadDes.get();
        if (des == null) {
            des = new TDeserializer();
            threadDes.set(des);
        }
        return des;
    }

    public static void sleep(long millis) {
        try {
            Time.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public static UptimeComputer makeUptimeComputer() {
        return _instance.makeUptimeComputerImpl();
    }

    public static <K, V> HashMap<V, List<K>> reverseMap(Map<K, V> map) {
        HashMap<V, ArrayList<K>> rtn = new HashMap<V, ArrayList<K>>();
        if (map == null) {
            return rtn;
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            K key = entry.getKey();
            V val = entry.getValue();
            ArrayList<K> list = (ArrayList<K>)rtn.get(val);
            if (list == null) {
                list = new ArrayList<K>();
                rtn.put(entry.getValue(), list);
            }
            list.add(key);
        }
        return rtn;
    }

    public static boolean isOnWindows() {
        if (System.getenv("OS") != null) {
            return System.getenv("OS").equals("Windows_NT");
        }
        return false;
    }

    public static boolean checkFileExists(String path) {
        return Files.exists(new File(path).toPath(), new LinkOption[0]);
    }

    public static void forceDelete(String path) throws IOException {
        _instance.forceDeleteImpl(path);
    }

    public static byte[] serialize(Object obj) {
        return serializationDelegate.serialize(obj);
    }

    public static <T> T deserialize(byte[] serialized, Class<T> clazz) {
        return serializationDelegate.deserialize(serialized, clazz);
    }

    public static byte[] toByteArray(ByteBuffer buffer) {
        byte[] ret = new byte[buffer.remaining()];
        buffer.get(ret, 0, ret.length);
        return ret;
    }

    public static Runnable mkSuicideFn() {
        return new Runnable(){

            @Override
            public void run() {
                Utils.exitProcess(1, "Worker died");
            }
        };
    }

    public static void readAndLogStream(String prefix, InputStream in) {
        try {
            BufferedReader r = new BufferedReader(new InputStreamReader(in));
            String line = null;
            while ((line = r.readLine()) != null) {
                LOG.info("{}:{}", (Object)prefix, (Object)line);
            }
        }
        catch (IOException e) {
            LOG.warn("Error while trying to log stream", (Throwable)e);
        }
    }

    private static SerializationDelegate getSerializationDelegate(Map<String, Object> topoConf) {
        SerializationDelegate delegate;
        String delegateClassName = (String)topoConf.get("storm.meta.serialization.delegate");
        try {
            Class<?> delegateClass = Class.forName(delegateClassName);
            delegate = (SerializationDelegate)delegateClass.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            LOG.error("Failed to construct serialization delegate, falling back to default", (Throwable)e);
            delegate = new DefaultSerializationDelegate();
        }
        delegate.prepare(topoConf);
        return delegate;
    }

    public static ComponentCommon getComponentCommon(StormTopology topology, String id) {
        if (topology.get_spouts().containsKey(id)) {
            return topology.get_spouts().get(id).get_common();
        }
        if (topology.get_bolts().containsKey(id)) {
            return topology.get_bolts().get(id).get_common();
        }
        if (topology.get_state_spouts().containsKey(id)) {
            return topology.get_state_spouts().get(id).get_common();
        }
        throw new IllegalArgumentException("Could not find component with id " + id);
    }

    public static List<Object> tuple(Object ... values) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Object v : values) {
            ret.add(v);
        }
        return ret;
    }

    public static byte[] gzip(byte[] data) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            GZIPOutputStream out = new GZIPOutputStream(bos);
            out.write(data);
            out.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] gunzip(byte[] data) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ByteArrayInputStream bis = new ByteArrayInputStream(data);
            GZIPInputStream in = new GZIPInputStream(bis);
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = in.read(buffer)) >= 0) {
                bos.write(buffer, 0, len);
            }
            in.close();
            bos.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> getRepeat(List<String> list) {
        ArrayList<String> rtn = new ArrayList<String>();
        HashSet<String> idSet = new HashSet<String>();
        for (String id : list) {
            if (idSet.contains(id)) {
                rtn.add(id);
                continue;
            }
            idSet.add(id);
        }
        return rtn;
    }

    public static GlobalStreamId getGlobalStreamId(String streamId, String componentId) {
        if (componentId == null) {
            return new GlobalStreamId(streamId, DEFAULT_STREAM_ID);
        }
        return new GlobalStreamId(streamId, componentId);
    }

    public static Object getSetComponentObject(ComponentObject obj) {
        if (obj.getSetField() == ComponentObject._Fields.SERIALIZED_JAVA) {
            return Utils.javaDeserialize(obj.get_serialized_java(), Serializable.class);
        }
        if (obj.getSetField() == ComponentObject._Fields.JAVA_OBJECT) {
            return obj.get_java_object();
        }
        return obj.get_shell();
    }

    public static int toPositive(int number) {
        return number & Integer.MAX_VALUE;
    }

    public static String processPid() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        String[] split = name.split("@");
        if (split.length != 2) {
            throw new RuntimeException("Got unexpected process name: " + name);
        }
        return split[0];
    }

    public static Map<String, Object> fromCompressedJsonConf(byte[] serialized) {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(serialized);
            InputStreamReader in = new InputStreamReader(new GZIPInputStream(bis));
            Object ret = JSONValue.parseWithException((Reader)in);
            in.close();
            return (Map)ret;
        }
        catch (IOException | ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> redactValue(Map<String, Object> m, String key) {
        if (m.containsKey(key)) {
            HashMap<String, Object> newMap = new HashMap<String, Object>(m);
            Object value = newMap.get(key);
            String v = value.toString();
            String redacted = new String(new char[v.length()]).replace("\u0000", "#");
            newMap.put(key, redacted);
            return newMap;
        }
        return m;
    }

    public static void setupDefaultUncaughtExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable thrown) {
                try {
                    Utils.handleUncaughtException(thrown);
                }
                catch (Error err) {
                    LOG.error("Received error in main thread.. terminating server...", (Throwable)err);
                    Runtime.getRuntime().exit(-2);
                }
            }
        });
    }

    public static Map<String, Object> findAndReadConfigFile(String name) {
        return Utils.findAndReadConfigFile(name, true);
    }

    public static HashMap reverseMap(List listSeq) {
        HashMap rtn = new HashMap();
        if (listSeq == null) {
            return rtn;
        }
        for (Object entry : listSeq) {
            List listEntry = (List)entry;
            Object key = listEntry.get(0);
            Object val = listEntry.get(1);
            ArrayList list = (ArrayList)rtn.get(val);
            if (list == null) {
                list = new ArrayList();
                rtn.put(val, list);
            }
            list.add(key);
        }
        return rtn;
    }

    public static Double parseJvmHeapMemByChildOpts(String input, Double defaultValue) {
        if (input != null) {
            Pattern optsPattern = Pattern.compile("Xmx[0-9]+[mkgMKG]");
            Matcher m = optsPattern.matcher(input);
            String memoryOpts = null;
            while (m.find()) {
                memoryOpts = m.group();
            }
            if (memoryOpts != null) {
                int unit = 1;
                if ((memoryOpts = memoryOpts.toLowerCase()).endsWith("k")) {
                    unit = 1024;
                } else if (memoryOpts.endsWith("m")) {
                    unit = 0x100000;
                } else if (memoryOpts.endsWith("g")) {
                    unit = 0x40000000;
                }
                memoryOpts = memoryOpts.replaceAll("[a-zA-Z]", "");
                Double result2 = Double.parseDouble(memoryOpts) * (double)unit / 1024.0 / 1024.0;
                return result2 < 1.0 ? 1.0 : result2;
            }
            return defaultValue;
        }
        return defaultValue;
    }

    public static ClientBlobStore getClientBlobStore(Map<String, Object> conf) {
        ClientBlobStore store = (ClientBlobStore)ReflectionUtils.newInstance((String)conf.get("client.blobstore.class"));
        store.prepare(conf);
        return store;
    }

    private static Object normalizeConfValue(Object obj) {
        if (obj instanceof Map) {
            return Utils.normalizeConf((Map)obj);
        }
        if (obj instanceof Collection) {
            ArrayList<Object> confList = new ArrayList<Object>((Collection)obj);
            for (int i = 0; i < confList.size(); ++i) {
                Object val = confList.get(i);
                confList.set(i, Utils.normalizeConfValue(val));
            }
            return confList;
        }
        if (obj instanceof Integer) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof Float) {
            return ((Float)obj).doubleValue();
        }
        return obj;
    }

    private static Map<String, Object> normalizeConf(Map<String, Object> conf) {
        if (conf == null) {
            return new HashMap<String, Object>();
        }
        HashMap<String, Object> ret = new HashMap<String, Object>(conf);
        for (Map.Entry entry : ret.entrySet()) {
            ret.put((String)entry.getKey(), Utils.normalizeConfValue(entry.getValue()));
        }
        return ret;
    }

    public static boolean isValidConf(Map<String, Object> topoConf) {
        return Utils.normalizeConf(topoConf).equals(Utils.normalizeConf((Map)JSONValue.parse((String)JSONValue.toJSONString(topoConf))));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TopologyInfo getTopologyInfo(String name, String asUser, Map<String, Object> topoConf) {
        try (NimbusClient client = NimbusClient.getConfiguredClientAs(topoConf, asUser);){
            String topologyId = Utils.getTopologyId(name, client.getClient());
            if (null != topologyId) {
                TopologyInfo topologyInfo = client.getClient().getTopologyInfo(topologyId);
                return topologyInfo;
            }
            TopologyInfo topologyInfo = null;
            return topologyInfo;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getTopologyId(String name, Nimbus.Iface client) {
        try {
            ClusterSummary summary = client.getClusterInfo();
            for (TopologySummary s : summary.get_topologies()) {
                if (!s.get_name().equals(name)) continue;
                return s.get_id();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static void validateTopologyBlobStoreMap(Map<String, Object> topoConf, Set<String> blobStoreKeys) throws InvalidTopologyException {
        Map blobStoreMap = (Map)topoConf.get("topology.blobstore.map");
        if (blobStoreMap != null) {
            Set mapKeys = blobStoreMap.keySet();
            HashSet<String> missingKeys = new HashSet<String>();
            for (String key : mapKeys) {
                if (blobStoreKeys.contains(key)) continue;
                missingKeys.add(key);
            }
            if (!missingKeys.isEmpty()) {
                throw new InvalidTopologyException("The topology blob store map does not contain the valid keys to launch the topology " + missingKeys);
            }
        }
    }

    public static String threadDump() {
        ThreadInfo[] threadInfos;
        StringBuilder dump = new StringBuilder();
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        for (ThreadInfo threadInfo : threadInfos = threadMXBean.getThreadInfo(threadMXBean.getAllThreadIds(), 100)) {
            StackTraceElement[] stackTraceElements;
            dump.append('\"');
            dump.append(threadInfo.getThreadName());
            dump.append("\" ");
            dump.append("\n   lock: ");
            dump.append(threadInfo.getLockName());
            dump.append(" owner: ");
            dump.append(threadInfo.getLockOwnerName());
            Thread.State state = threadInfo.getThreadState();
            dump.append("\n   java.lang.Thread.State: ");
            dump.append((Object)state);
            for (StackTraceElement stackTraceElement : stackTraceElements = threadInfo.getStackTrace()) {
                dump.append("\n        at ");
                dump.append(stackTraceElement);
            }
            dump.append("\n\n");
        }
        return dump.toString();
    }

    public static boolean checkDirExists(String dir) {
        File file = new File(dir);
        return file.isDirectory();
    }

    public static Object getConfiguredClass(Map<String, Object> conf, Object configKey) {
        if (conf.containsKey(configKey)) {
            return ReflectionUtils.newInstance((String)conf.get(configKey));
        }
        return null;
    }

    public static boolean isZkAuthenticationConfiguredStormServer(Map<String, Object> conf) {
        return null != System.getProperty("java.security.auth.login.config") || conf != null && conf.get("storm.zookeeper.auth.scheme") != null && !((String)conf.get("storm.zookeeper.auth.scheme")).isEmpty();
    }

    public static byte[] toCompressedJsonConf(Map<String, Object> topoConf) {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            OutputStreamWriter out = new OutputStreamWriter(new GZIPOutputStream(bos));
            JSONValue.writeJSONString(topoConf, (Writer)out);
            out.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static double nullToZero(Double v) {
        return v != null ? v : 0.0;
    }

    public static <V> V OR(V a, V b) {
        return a == null ? b : a;
    }

    public static TreeMap<Integer, Integer> integerDivided(int sum, int numPieces) {
        int base = sum / numPieces;
        int numInc = sum % numPieces;
        int numBases = numPieces - numInc;
        TreeMap<Integer, Integer> ret = new TreeMap<Integer, Integer>();
        ret.put(base, numBases);
        if (numInc != 0) {
            ret.put(base + 1, numInc);
        }
        return ret;
    }

    public static <T> List<List<T>> partitionFixed(int maxNumChunks, Collection<T> coll) {
        ArrayList<List<T>> ret = new ArrayList<List<T>>();
        if (maxNumChunks == 0 || coll == null) {
            return ret;
        }
        TreeMap<Integer, Integer> parts = Utils.integerDivided(coll.size(), maxNumChunks);
        ArrayList sortedKeys = new ArrayList(parts.keySet());
        Collections.sort(sortedKeys, Collections.reverseOrder());
        Iterator<T> it = coll.iterator();
        for (Integer chunkSize : sortedKeys) {
            if (!it.hasNext()) break;
            Integer times = (Integer)parts.get(chunkSize);
            for (int i = 0; i < times && it.hasNext(); ++i) {
                ArrayList<T> chunkList = new ArrayList<T>();
                for (int j = 0; j < chunkSize && it.hasNext(); ++j) {
                    chunkList.add(it.next());
                }
                ret.add(chunkList);
            }
        }
        return ret;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Object readYamlFile(String yamlFile) {
        try (FileReader reader = new FileReader(yamlFile);){
            Object object = new Yaml((BaseConstructor)new SafeConstructor()).load((Reader)reader);
            return object;
        }
        catch (Exception ex) {
            LOG.error("Failed to read yaml file.", (Throwable)ex);
            return null;
        }
    }

    public static int getAvailablePort(int prefferedPort) {
        int localPort;
        block14: {
            localPort = -1;
            try (ServerSocket socket = new ServerSocket(prefferedPort);){
                localPort = socket.getLocalPort();
            }
            catch (IOException exp) {
                if (prefferedPort <= 0) break block14;
                return Utils.getAvailablePort(0);
            }
        }
        return localPort;
    }

    public static int getAvailablePort() {
        return Utils.getAvailablePort(0);
    }

    public static <T> T findOne(IPredicate<T> pred, Collection<T> coll) {
        if (coll == null) {
            return null;
        }
        for (T elem : coll) {
            if (!pred.test(elem)) continue;
            return elem;
        }
        return null;
    }

    public static <T, U> T findOne(IPredicate<T> pred, Map<U, T> map) {
        if (map == null) {
            return null;
        }
        return (T)Utils.findOne(pred, map.entrySet());
    }

    protected void forceDeleteImpl(String path) throws IOException {
        LOG.debug("Deleting path {}", (Object)path);
        if (Utils.checkFileExists(path)) {
            try {
                FileUtils.forceDelete((File)new File(path));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    public UptimeComputer makeUptimeComputerImpl() {
        return new UptimeComputer();
    }

    protected String localHostnameImpl() throws UnknownHostException {
        return InetAddress.getLocalHost().getCanonicalHostName();
    }

    public static String memoizedLocalHostname() throws UnknownHostException {
        if (memoizedLocalHostnameString == null) {
            memoizedLocalHostnameString = Utils.localHostname();
        }
        return memoizedLocalHostnameString;
    }

    protected String hostnameImpl() throws UnknownHostException {
        if (localConf == null) {
            return Utils.memoizedLocalHostname();
        }
        Object hostnameString = localConf.get("storm.local.hostname");
        if (hostnameString == null || hostnameString.equals("")) {
            return Utils.memoizedLocalHostname();
        }
        return (String)hostnameString;
    }

    public static class UptimeComputer {
        int startTime = Time.currentTimeSecs();

        public int upTime() {
            return Time.deltaSecs(this.startTime);
        }
    }

    public static class SmartThread
    extends Thread {
        public boolean isSleeping() {
            return Time.isThreadWaiting(this);
        }

        public SmartThread(Runnable r) {
            super(r);
        }
    }
}

