/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class VersionInfo {
    private Properties info = new Properties();
    private static final VersionInfo COMMON_VERSION_INFO = new VersionInfo("storm-core");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected VersionInfo(String component) {
        String versionInfoFile = component + "-version-info.properties";
        InputStream is = null;
        try {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(versionInfoFile);
            if (is == null) {
                throw new IOException("Resource not found");
            }
            this.info.load(is);
        }
        catch (IOException iOException) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected String _getVersion() {
        return this.info.getProperty("version", "Unknown");
    }

    protected String _getRevision() {
        return this.info.getProperty("revision", "Unknown");
    }

    protected String _getBranch() {
        return this.info.getProperty("branch", "Unknown");
    }

    protected String _getDate() {
        return this.info.getProperty("date", "Unknown");
    }

    protected String _getUser() {
        return this.info.getProperty("user", "Unknown");
    }

    protected String _getUrl() {
        return this.info.getProperty("url", "Unknown");
    }

    protected String _getSrcChecksum() {
        return this.info.getProperty("srcChecksum", "Unknown");
    }

    protected String _getBuildVersion() {
        return VersionInfo.getVersion() + " from " + this._getRevision() + " by " + this._getUser() + " source checksum " + this._getSrcChecksum();
    }

    public static String getVersion() {
        return COMMON_VERSION_INFO._getVersion();
    }

    public static String getRevision() {
        return COMMON_VERSION_INFO._getRevision();
    }

    public static String getBranch() {
        return COMMON_VERSION_INFO._getBranch();
    }

    public static String getDate() {
        return COMMON_VERSION_INFO._getDate();
    }

    public static String getUser() {
        return COMMON_VERSION_INFO._getUser();
    }

    public static String getUrl() {
        return COMMON_VERSION_INFO._getUrl();
    }

    public static String getSrcChecksum() {
        return COMMON_VERSION_INFO._getSrcChecksum();
    }

    public static String getBuildVersion() {
        return COMMON_VERSION_INFO._getBuildVersion();
    }

    public static void main(String[] args) {
        System.out.println("Storm " + VersionInfo.getVersion());
        System.out.println("URL " + VersionInfo.getUrl() + " -r " + VersionInfo.getRevision());
        System.out.println("Branch " + VersionInfo.getBranch());
        System.out.println("Compiled by " + VersionInfo.getUser() + " on " + VersionInfo.getDate());
        System.out.println("From source with checksum " + VersionInfo.getSrcChecksum());
    }
}

