/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

public class WindowedTimeThrottler {
    long _windowMillis;
    int _maxAmt;
    long _windowStartTime;
    int _windowEvents = 0;

    public WindowedTimeThrottler(Number windowMillis, Number maxAmt) {
        this._windowMillis = windowMillis.longValue();
        this._maxAmt = maxAmt.intValue();
        this._windowStartTime = System.currentTimeMillis();
    }

    public boolean isThrottled() {
        this.resetIfNecessary();
        return this._windowEvents >= this._maxAmt;
    }

    public void markEvent() {
        this.resetIfNecessary();
        ++this._windowEvents;
    }

    private void resetIfNecessary() {
        long now = System.currentTimeMillis();
        if (now - this._windowStartTime > this._windowMillis) {
            this._windowStartTime = now;
            this._windowEvents = 0;
        }
    }
}

