/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.utils;

import org.apache.storm.utils.BackpressureUncaughtExceptionHandler;
import org.apache.storm.utils.WorkerBackpressureCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerBackpressureThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(WorkerBackpressureThread.class);
    private final Object trigger;
    private final Object workerData;
    private final WorkerBackpressureCallback callback;
    private volatile boolean running = true;

    public WorkerBackpressureThread(Object trigger, Object workerData, WorkerBackpressureCallback callback) {
        this.trigger = trigger;
        this.workerData = workerData;
        this.callback = callback;
        this.setName("WorkerBackpressureThread");
        this.setDaemon(true);
        this.setUncaughtExceptionHandler(new BackpressureUncaughtExceptionHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyBackpressureChecker(Object trigger) {
        try {
            Object object = trigger;
            synchronized (object) {
                trigger.notifyAll();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void terminate() throws InterruptedException {
        this.running = false;
        this.interrupt();
        this.join();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.running) {
            try {
                Object object = this.trigger;
                synchronized (object) {
                    this.trigger.wait(100L);
                }
                this.callback.onEvent(this.workerData);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

