/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.windowing;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.storm.windowing.DefaultEvictionContext;
import org.apache.storm.windowing.Event;
import org.apache.storm.windowing.EvictionPolicy;
import org.apache.storm.windowing.TriggerHandler;
import org.apache.storm.windowing.TriggerPolicy;

public class CountTriggerPolicy<T>
implements TriggerPolicy<T> {
    private final int count;
    private final AtomicInteger currentCount;
    private final TriggerHandler handler;
    private final EvictionPolicy<T> evictionPolicy;
    private boolean started;

    public CountTriggerPolicy(int count, TriggerHandler handler, EvictionPolicy<T> evictionPolicy) {
        this.count = count;
        this.currentCount = new AtomicInteger();
        this.handler = handler;
        this.evictionPolicy = evictionPolicy;
        this.started = false;
    }

    @Override
    public void track(Event<T> event) {
        if (this.started && !event.isWatermark() && this.currentCount.incrementAndGet() >= this.count) {
            this.evictionPolicy.setContext(new DefaultEvictionContext(System.currentTimeMillis()));
            this.handler.onTrigger();
        }
    }

    @Override
    public void reset() {
        this.currentCount.set(0);
    }

    @Override
    public void start() {
        this.started = true;
    }

    @Override
    public void shutdown() {
    }

    public String toString() {
        return "CountTriggerPolicy{count=" + this.count + ", currentCount=" + this.currentCount + ", started=" + this.started + '}';
    }
}

