/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.windowing;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.storm.generated.GlobalStreamId;
import org.apache.storm.topology.FailedException;
import org.apache.storm.windowing.WaterMarkEvent;
import org.apache.storm.windowing.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaterMarkEventGenerator<T>
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(WaterMarkEventGenerator.class);
    private final WindowManager<T> windowManager;
    private final int eventTsLag;
    private final Set<GlobalStreamId> inputStreams;
    private final Map<GlobalStreamId, Long> streamToTs;
    private final ScheduledExecutorService executorService;
    private final int interval;
    private ScheduledFuture<?> executorFuture;
    private long lastWaterMarkTs = 0L;

    public WaterMarkEventGenerator(WindowManager<T> windowManager, int interval, int eventTsLag, Set<GlobalStreamId> inputStreams) {
        this.windowManager = windowManager;
        this.streamToTs = new ConcurrentHashMap<GlobalStreamId, Long>();
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.interval = interval;
        this.eventTsLag = eventTsLag;
        this.inputStreams = inputStreams;
    }

    public boolean track(GlobalStreamId stream, long ts) {
        Long currentVal = this.streamToTs.get(stream);
        if (currentVal == null || ts > currentVal) {
            this.streamToTs.put(stream, ts);
        }
        this.checkFailures();
        return ts >= this.lastWaterMarkTs;
    }

    @Override
    public void run() {
        try {
            long waterMarkTs = this.computeWaterMarkTs();
            if (waterMarkTs > this.lastWaterMarkTs) {
                this.windowManager.add(new WaterMarkEvent(waterMarkTs));
                this.lastWaterMarkTs = waterMarkTs;
            }
        }
        catch (Throwable th) {
            LOG.error("Failed while processing watermark event ", th);
            throw th;
        }
    }

    private long computeWaterMarkTs() {
        long ts = 0L;
        if (this.streamToTs.size() >= this.inputStreams.size()) {
            ts = Long.MAX_VALUE;
            for (Map.Entry<GlobalStreamId, Long> entry : this.streamToTs.entrySet()) {
                ts = Math.min(ts, entry.getValue());
            }
        }
        return ts - (long)this.eventTsLag;
    }

    private void checkFailures() {
        if (this.executorFuture != null && this.executorFuture.isDone()) {
            try {
                this.executorFuture.get();
            }
            catch (InterruptedException ex) {
                LOG.error("Got exception ", (Throwable)ex);
                throw new FailedException(ex);
            }
            catch (ExecutionException ex) {
                LOG.error("Got exception ", (Throwable)ex);
                throw new FailedException(ex.getCause());
            }
        }
    }

    public void start() {
        this.executorFuture = this.executorService.scheduleAtFixedRate(this, this.interval, this.interval, TimeUnit.MILLISECONDS);
    }
}

