/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.windowing;

import org.apache.storm.windowing.CountEvictionPolicy;
import org.apache.storm.windowing.Event;
import org.apache.storm.windowing.EvictionContext;
import org.apache.storm.windowing.EvictionPolicy;

public class WatermarkCountEvictionPolicy<T>
extends CountEvictionPolicy<T> {
    private long processed = 0L;

    public WatermarkCountEvictionPolicy(int count) {
        super(count);
    }

    @Override
    public EvictionPolicy.Action evict(Event<T> event) {
        EvictionPolicy.Action action;
        if (event.getTimestamp() <= this.getContext().getReferenceTime() && this.processed < this.currentCount.get()) {
            action = super.evict(event);
            if (action == EvictionPolicy.Action.PROCESS) {
                ++this.processed;
            }
        } else {
            action = EvictionPolicy.Action.KEEP;
        }
        return action;
    }

    @Override
    public void track(Event<T> event) {
    }

    @Override
    public void setContext(EvictionContext context) {
        super.setContext(context);
        if (context.getCurrentCount() != null) {
            this.currentCount.set(context.getCurrentCount());
        } else {
            this.currentCount.set(this.processed + context.getSlidingCount());
        }
        this.processed = 0L;
    }

    @Override
    public String toString() {
        return "WatermarkCountEvictionPolicy{} " + super.toString();
    }
}

