/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hbase.security;

import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.storm.hbase.security.AutoHBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseSecurityUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseSecurityUtil.class);
    public static final String STORM_KEYTAB_FILE_KEY = "storm.keytab.file";
    public static final String STORM_USER_NAME_KEY = "storm.kerberos.principal";

    public static UserProvider login(Map conf, Configuration hbaseConfig) throws IOException {
        UserProvider provider = UserProvider.instantiate((Configuration)hbaseConfig);
        if (conf.get("topology.auto-credentials") == null || !((List)conf.get("topology.auto-credentials")).contains(AutoHBase.class.getName())) {
            LOG.info("Logging in using keytab as AutoHBase is not specified for topology.auto-credentials");
            if (UserGroupInformation.isSecurityEnabled()) {
                String userName;
                String keytab = (String)conf.get(STORM_KEYTAB_FILE_KEY);
                if (keytab != null) {
                    hbaseConfig.set(STORM_KEYTAB_FILE_KEY, keytab);
                }
                if ((userName = (String)conf.get(STORM_USER_NAME_KEY)) != null) {
                    hbaseConfig.set(STORM_USER_NAME_KEY, userName);
                }
                provider.login(STORM_KEYTAB_FILE_KEY, STORM_USER_NAME_KEY, InetAddress.getLocalHost().getCanonicalHostName());
            }
        }
        return provider;
    }
}

