/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hbase.bolt;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.storm.hbase.bolt.mapper.HBaseMapper;
import org.apache.storm.hbase.common.HBaseClient;
import org.apache.storm.task.OutputCollector;
import org.apache.storm.task.TopologyContext;
import org.apache.storm.topology.base.BaseRichBolt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHBaseBolt
extends BaseRichBolt {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHBaseBolt.class);
    protected transient OutputCollector collector;
    protected transient HBaseClient hBaseClient;
    protected String tableName;
    protected HBaseMapper mapper;
    protected String configKey;

    public AbstractHBaseBolt(String tableName, HBaseMapper mapper) {
        Validate.notEmpty((String)tableName, (String)"Table name can not be blank or null");
        Validate.notNull((Object)mapper, (String)"mapper can not be null");
        this.tableName = tableName;
        this.mapper = mapper;
    }

    public void prepare(Map<String, Object> topoConf, TopologyContext topologyContext, OutputCollector collector) {
        this.collector = collector;
        Configuration hbConfig = HBaseConfiguration.create();
        Map conf = (Map)topoConf.get(this.configKey);
        if (conf == null) {
            throw new IllegalArgumentException("HBase configuration not found using key '" + this.configKey + "'");
        }
        if (conf.get("hbase.rootdir") == null) {
            LOG.warn("No 'hbase.rootdir' value found in configuration! Using HBase defaults.");
        }
        for (String key : conf.keySet()) {
            hbConfig.set(key, String.valueOf(conf.get(key)));
        }
        HashMap<String, Object> hbaseConfMap = new HashMap<String, Object>(conf);
        hbaseConfMap.put("topology.auto-credentials", topoConf.get("topology.auto-credentials"));
        this.hBaseClient = new HBaseClient(hbaseConfMap, hbConfig, this.tableName);
    }

    public void cleanup() {
        try {
            this.hBaseClient.close();
        }
        catch (IOException e) {
            LOG.error("HBase Client Close Failed ", (Throwable)e);
        }
    }
}

