/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hbase.trident.state;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Result;
import org.apache.storm.hbase.bolt.mapper.HBaseProjectionCriteria;
import org.apache.storm.hbase.bolt.mapper.HBaseValueMapper;
import org.apache.storm.hbase.common.ColumnList;
import org.apache.storm.hbase.common.HBaseClient;
import org.apache.storm.hbase.trident.mapper.TridentHBaseMapper;
import org.apache.storm.topology.FailedException;
import org.apache.storm.trident.operation.TridentCollector;
import org.apache.storm.trident.state.State;
import org.apache.storm.trident.tuple.TridentTuple;
import org.apache.storm.tuple.ITuple;
import org.apache.storm.tuple.Values;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseState
implements State {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseState.class);
    private Options options;
    private HBaseClient hBaseClient;
    private Map map;
    private int numPartitions;
    private int partitionIndex;

    protected HBaseState(Map map, int partitionIndex, int numPartitions, Options options) {
        this.options = options;
        this.map = map;
        this.partitionIndex = partitionIndex;
        this.numPartitions = numPartitions;
    }

    protected void prepare() {
        Configuration hbConfig = HBaseConfiguration.create();
        Map conf = (Map)this.map.get(this.options.configKey);
        if (conf == null) {
            LOG.info("HBase configuration not found using key '" + this.options.configKey + "'");
            LOG.info("Using HBase config from first hbase-site.xml found on classpath.");
        } else {
            if (conf.get("hbase.rootdir") == null) {
                LOG.warn("No 'hbase.rootdir' value found in configuration! Using HBase defaults.");
            }
            for (String key : conf.keySet()) {
                hbConfig.set(key, String.valueOf(conf.get(key)));
            }
        }
        HashMap<String, Object> hbaseConfMap = new HashMap<String, Object>(conf);
        hbaseConfMap.put("topology.auto-credentials", this.map.get("topology.auto-credentials"));
        this.hBaseClient = new HBaseClient(hbaseConfMap, hbConfig, this.options.tableName);
    }

    public void beginCommit(Long aLong) {
        LOG.debug("beginCommit is noop.");
    }

    public void commit(Long aLong) {
        LOG.debug("commit is noop.");
    }

    public void updateState(List<TridentTuple> tuples, TridentCollector collector) {
        ArrayList mutations = Lists.newArrayList();
        for (TridentTuple tuple : tuples) {
            byte[] rowKey = this.options.mapper.rowKey(tuple);
            ColumnList cols = this.options.mapper.columns(tuple);
            mutations.addAll(this.hBaseClient.constructMutationReq(rowKey, cols, this.options.durability));
        }
        try {
            this.hBaseClient.batchMutate(mutations);
        }
        catch (Exception e) {
            collector.reportError((Throwable)e);
            throw new FailedException((Throwable)e);
        }
    }

    public List<List<Values>> batchRetrieve(List<TridentTuple> tridentTuples) {
        ArrayList batchRetrieveResult = Lists.newArrayList();
        ArrayList gets = Lists.newArrayList();
        for (TridentTuple tuple : tridentTuples) {
            byte[] rowKey = this.options.mapper.rowKey(tuple);
            gets.add(this.hBaseClient.constructGetRequests(rowKey, this.options.projectionCriteria));
        }
        try {
            Result[] results = this.hBaseClient.batchGet(gets);
            for (int i = 0; i < results.length; ++i) {
                Result result = results[i];
                TridentTuple tuple = tridentTuples.get(i);
                List<Values> values = this.options.rowToStormValueMapper.toValues((ITuple)tuple, result);
                batchRetrieveResult.add(values);
            }
        }
        catch (Exception e) {
            LOG.warn("Batch get operation failed. Triggering replay.", (Throwable)e);
            throw new FailedException((Throwable)e);
        }
        return batchRetrieveResult;
    }

    public static class Options
    implements Serializable {
        private TridentHBaseMapper mapper;
        private Durability durability = Durability.SKIP_WAL;
        private HBaseProjectionCriteria projectionCriteria;
        private HBaseValueMapper rowToStormValueMapper;
        private String configKey;
        private String tableName;

        public Options withDurability(Durability durability) {
            this.durability = durability;
            return this;
        }

        public Options withProjectionCriteria(HBaseProjectionCriteria projectionCriteria) {
            this.projectionCriteria = projectionCriteria;
            return this;
        }

        public Options withConfigKey(String configKey) {
            this.configKey = configKey;
            return this;
        }

        public Options withTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Options withRowToStormValueMapper(HBaseValueMapper rowToStormValueMapper) {
            this.rowToStormValueMapper = rowToStormValueMapper;
            return this;
        }

        public Options withMapper(TridentHBaseMapper mapper) {
            this.mapper = mapper;
            return this;
        }
    }
}

