/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.common;

import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.client.HdfsDataOutputStream;
import org.apache.storm.hdfs.bolt.format.RecordFormat;
import org.apache.storm.hdfs.bolt.rotation.FileRotationPolicy;
import org.apache.storm.hdfs.common.AbstractHDFSWriter;
import org.apache.storm.tuple.Tuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDFSWriter
extends AbstractHDFSWriter {
    private static final Logger LOG = LoggerFactory.getLogger(HDFSWriter.class);
    private FSDataOutputStream out;
    private RecordFormat format;

    public HDFSWriter(FileRotationPolicy policy, Path path, FSDataOutputStream out, RecordFormat format) {
        super(policy, path);
        this.out = out;
        this.format = format;
    }

    @Override
    protected void doWrite(Tuple tuple) throws IOException {
        byte[] bytes = this.format.format(tuple);
        this.out.write(bytes);
        this.offset += (long)bytes.length;
    }

    @Override
    protected void doSync() throws IOException {
        LOG.info("Attempting to sync all data to filesystem");
        if (this.out instanceof HdfsDataOutputStream) {
            ((HdfsDataOutputStream)this.out).hsync(EnumSet.of(HdfsDataOutputStream.SyncFlag.UPDATE_LENGTH));
        } else {
            this.out.hsync();
        }
    }

    @Override
    protected void doClose() throws IOException {
        this.out.close();
    }
}

