/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.trident.format;

import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.storm.hdfs.trident.format.FileNameFormat;
import org.apache.storm.utils.Utils;

public class SimpleFileNameFormat
implements FileNameFormat {
    private static final long serialVersionUID = 1L;
    private int partitionIndex;
    private String host;
    private String path = "/storm";
    private String name = "$TIME.$NUM.txt";
    private String timeFormat = "yyyyMMddHHmmss";

    @Override
    public String getName(long rotation, long timeStamp) {
        SimpleDateFormat dateFormat = new SimpleDateFormat(this.timeFormat);
        String ret = this.name.replace("$TIME", dateFormat.format(new Date(timeStamp))).replace("$NUM", String.valueOf(rotation)).replace("$HOST", this.host).replace("$PARTITION", String.valueOf(this.partitionIndex));
        return ret;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void prepare(Map<String, Object> conf, int partitionIndex, int numPartitions) {
        this.partitionIndex = partitionIndex;
        try {
            this.host = Utils.localHostname();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public SimpleFileNameFormat withPath(String path) {
        this.path = path;
        return this;
    }

    public SimpleFileNameFormat withName(String name) {
        this.name = name;
        return this;
    }

    public SimpleFileNameFormat withTimeFormat(String timeFormat) {
        try {
            new SimpleDateFormat(timeFormat);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid timeFormat: " + e.getMessage());
        }
        this.timeFormat = timeFormat;
        return this;
    }
}

