/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.hdfs.trident.rotation;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.storm.hdfs.trident.rotation.FileRotationPolicy;
import org.apache.storm.trident.tuple.TridentTuple;

public class TimedRotationPolicy
implements FileRotationPolicy {
    private long interval;
    private Timer rotationTimer;
    private AtomicBoolean rotationTimerTriggered = new AtomicBoolean();

    public TimedRotationPolicy(float count, TimeUnit units) {
        this.interval = (long)(count * (float)units.getMilliSeconds());
    }

    @Override
    public boolean mark(TridentTuple tuple, long offset) {
        return this.rotationTimerTriggered.get();
    }

    @Override
    public boolean mark(long offset) {
        return this.rotationTimerTriggered.get();
    }

    @Override
    public void reset() {
        this.rotationTimerTriggered.set(false);
    }

    public long getInterval() {
        return this.interval;
    }

    @Override
    public void start() {
        this.rotationTimer = new Timer(true);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                TimedRotationPolicy.this.rotationTimerTriggered.set(true);
            }
        };
        this.rotationTimer.scheduleAtFixedRate(task, this.interval, this.interval);
    }

    public static enum TimeUnit {
        SECONDS(1000L),
        MINUTES(60000L),
        HOURS(3600000L),
        DAYS(86400000L);

        private long milliSeconds;

        private TimeUnit(long milliSeconds) {
            this.milliSeconds = milliSeconds;
        }

        public long getMilliSeconds() {
            return this.milliSeconds;
        }
    }
}

