/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.blobstore;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.BackgroundPathAndBytesable;
import org.apache.storm.blobstore.BlobStoreUtils;
import org.apache.storm.generated.KeyNotFoundException;
import org.apache.storm.nimbus.NimbusInfo;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeySequenceNumber {
    private static final Logger LOG = LoggerFactory.getLogger(KeySequenceNumber.class);
    private final String BLOBSTORE_SUBTREE = "/blobstore";
    private final String BLOBSTORE_MAX_KEY_SEQUENCE_SUBTREE = "/blobstoremaxkeysequencenumber";
    private final String key;
    private final NimbusInfo nimbusInfo;
    private final int INT_CAPACITY = 4;
    private final int INITIAL_SEQUENCE_NUMBER = 1;

    public KeySequenceNumber(String key, NimbusInfo nimbusInfo) {
        this.key = key;
        this.nimbusInfo = nimbusInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getKeySequenceNumber(Map<String, Object> conf) throws KeyNotFoundException {
        TreeSet<Integer> sequenceNumbers = new TreeSet<Integer>();
        try (CuratorFramework zkClient = BlobStoreUtils.createZKClient(conf);){
            if (zkClient.checkExists().forPath("/blobstore/" + this.key) == null) {
                ((BackgroundPathAndBytesable)((ACLBackgroundPathAndBytesable)zkClient.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).withACL((List)ZooDefs.Ids.OPEN_ACL_UNSAFE)).forPath("/blobstoremaxkeysequencenumber/" + this.key);
                zkClient.setData().forPath("/blobstoremaxkeysequencenumber/" + this.key, ByteBuffer.allocate(4).putInt(1).array());
                int n = 1;
                return n;
            }
            List stateInfoList = (List)zkClient.getChildren().forPath("/blobstore/" + this.key);
            LOG.debug("stateInfoList-size {} stateInfoList-data {}", (Object)stateInfoList.size(), (Object)stateInfoList);
            if (stateInfoList.isEmpty()) {
                int n = this.getMaxSequenceNumber(zkClient);
                return n;
            }
            LOG.debug("stateInfoSize {}", (Object)stateInfoList.size());
            for (String stateInfo : stateInfoList) {
                sequenceNumbers.add(Integer.parseInt(BlobStoreUtils.normalizeNimbusHostPortSequenceNumberInfo(stateInfo).getSequenceNumber()));
            }
            int currentSeqNumber = this.getMaxSequenceNumber(zkClient);
            if (!this.checkIfStateContainsCurrentNimbusHost(stateInfoList, this.nimbusInfo) && !this.nimbusInfo.isLeader()) {
                if ((Integer)sequenceNumbers.last() < currentSeqNumber) {
                    int n = currentSeqNumber;
                    return n;
                }
                int n = 0;
                return n;
            }
            if (!this.checkIfStateContainsCurrentNimbusHost(stateInfoList, this.nimbusInfo) && this.nimbusInfo.isLeader()) {
                this.incrementMaxSequenceNumber(zkClient, currentSeqNumber);
                int n = currentSeqNumber + 1;
                return n;
            }
            if (sequenceNumbers.size() == 1) {
                if ((Integer)sequenceNumbers.first() < currentSeqNumber) {
                    this.incrementMaxSequenceNumber(zkClient, currentSeqNumber);
                    int n = currentSeqNumber + 1;
                    return n;
                }
                this.incrementMaxSequenceNumber(zkClient, currentSeqNumber);
                int n = (Integer)sequenceNumbers.first() + 1;
                return n;
            }
            int n = (Integer)sequenceNumbers.last();
            return n;
        }
    }

    private boolean checkIfStateContainsCurrentNimbusHost(List<String> stateInfoList, NimbusInfo nimbusInfo) {
        boolean containsNimbusHost = false;
        for (String stateInfo : stateInfoList) {
            if (!stateInfo.contains(nimbusInfo.getHost())) continue;
            containsNimbusHost = true;
            break;
        }
        return containsNimbusHost;
    }

    private void incrementMaxSequenceNumber(CuratorFramework zkClient, int count) throws Exception {
        zkClient.setData().forPath("/blobstoremaxkeysequencenumber/" + this.key, ByteBuffer.allocate(4).putInt(count + 1).array());
    }

    private int getMaxSequenceNumber(CuratorFramework zkClient) throws Exception {
        return ByteBuffer.wrap((byte[])zkClient.getData().forPath("/blobstoremaxkeysequencenumber/" + this.key)).getInt();
    }
}

